/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.taskUpdater;

import com.company.updater.TaskResult;
import com.company.updater.TaskResultWithErrorData;
import com.company.updater.taskUpdater.UpdaterTaskReader;
import com.company.updater.updaterTasks.UpdaterTask;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdaterTaskResultWriter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdaterTaskReader.class);
    private final String homePath;
    private List<TaskResult> taskResults = new ArrayList<TaskResult>();
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public UpdaterTaskResultWriter(String homePath) {
        this.homePath = homePath;
    }

    public void addTaskResult(UpdaterTask updaterTask, String[] resultData) {
        String result = resultData[0];
        String errorCode = resultData[1];
        String errorMsg = resultData[2];
        if (errorCode != null && !errorCode.equals("")) {
            if (errorMsg == null) {
                errorMsg = "";
            }
            TaskResultWithErrorData taskResult = new TaskResultWithErrorData(updaterTask.getUuid(), updaterTask.getTaskId(), result, errorCode, errorMsg);
            this.taskResults.add(taskResult);
            LOG.info("Add task result to write queue : " + taskResult.getTask_id() + " result : " + taskResult.getResult() + " errorCode : " + errorCode + " errorMsg : " + errorMsg);
        } else {
            TaskResult taskResult = new TaskResult(updaterTask.getUuid(), updaterTask.getTaskId(), result);
            this.taskResults.add(taskResult);
            LOG.info("Add task result to write queue : " + taskResult.getTask_id() + " result : " + taskResult.getResult());
        }
    }

    public void writeResults() {
        LOG.info("Start write task results {}", (Object)this.taskResults);
        ArrayList<TaskResult> firstFrResults = new ArrayList<TaskResult>();
        ArrayList<TaskResult> secondFrResults = new ArrayList<TaskResult>();
        String firstUuid = null;
        for (TaskResult taskResult : this.taskResults) {
            if (firstUuid == null) {
                firstUuid = taskResult.getUuid();
            }
            if (taskResult.getUuid().equals(firstUuid)) {
                firstFrResults.add(taskResult);
                continue;
            }
            secondFrResults.add(taskResult);
        }
        this.writeTaskResultsWithUiid(firstUuid, firstFrResults);
        if (!secondFrResults.isEmpty()) {
            this.writeTaskResultsWithUiid(((TaskResult)secondFrResults.get(0)).getUuid(), secondFrResults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTaskResultsWithUiid(String uuid, List<TaskResult> taskResults) {
        BufferedWriter output = null;
        String jsonTaskResult = this.gson.toJson(taskResults);
        try {
            File file = new File(this.homePath + File.separator + "tasks" + File.separator + "updater_results" + "_" + uuid + ".tsk");
            output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath()), "UTF-8"));
            output.write(jsonTaskResult);
            LOG.info("End write task result data {}", (Object)jsonTaskResult);
        }
        catch (IOException e) {
            String error = "Error write file " + e.getMessage();
            LOG.error(error);
        }
        finally {
            if (output != null) {
                try {
                    output.flush();
                    output.close();
                }
                catch (IOException e) {
                    LOG.error("Error close file {}", (Object)e.getMessage());
                }
            }
        }
    }
}

