/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.softwareUpdater;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteFileThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteFileThread.class);
    private File file;
    private long timeStart;
    private final long timeOut = 3000L;
    private volatile boolean result = false;
    private volatile boolean stop = false;

    private DeleteFileThread(File file) {
        this.file = file;
        this.start();
    }

    public boolean getResult() {
        return this.result;
    }

    public static boolean deleteFile(File file) {
        DeleteFileThread instance = new DeleteFileThread(file);
        try {
            while (instance.isAlive()) {
                Thread.sleep(20L);
            }
            return instance.getResult();
        }
        catch (Exception e) {
            LOG.error("Error in DeleteFileThread {}", e);
            return false;
        }
    }

    @Override
    public void run() {
        LOG.info(" + DeleteFileThread start");
        LOG.info("Try delete {}", (Object)this.file.getAbsoluteFile());
        this.timeStart = System.currentTimeMillis();
        while (!this.stop) {
            try {
                if (!this.file.exists()) {
                    LOG.info("Delete successful! path file is {}", (Object)this.file.getAbsoluteFile());
                    this.result = true;
                    this.stop = true;
                    continue;
                }
                if (this.file.delete()) {
                    LOG.info("Delete successful! path file is {}", (Object)this.file.getAbsoluteFile());
                    this.result = true;
                    this.stop = true;
                    continue;
                }
                if (this.timeStart + 3000L > System.currentTimeMillis()) {
                    this.result = false;
                    this.stop = true;
                    continue;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Exception e) {
                this.result = false;
                this.stop = true;
                LOG.error("Error in DeleteFileThread {}", e);
            }
        }
        LOG.info(" - DeleteFileThread end");
    }
}

