/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.softwareUpdater;

import com.company.updater.UnzipUtil;
import com.company.updater.UpdaterUtils;
import com.company.updater.softwareUpdater.ChangeFileThread;
import com.company.updater.softwareUpdater.DeleteFileThread;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(ClientUpdater.class);
    private static String oldFilePath = "";
    private static String newFilePath = "";
    private static String backupOldPath = "";
    private static boolean comProxyIsStopped = false;
    private static final long timeOut = 30000L;
    private static final long COMPPROXY_STOP_TIME_OUT = 15000L;
    private static final String AGENT_LIBS_FOLDER_NAME = File.separator + "agent" + File.separator + "libs";
    private static String serviceName = "comproxy.sh";
    private static String servicePath = "/home/tc/storage/comproxy";
    private static String localServicePath = "/usr/local/comproxy";
    private static String homePath = "";
    private String archiveName = "";
    private static List<String> excludeFiles = new ArrayList<String>();
    private static String[] excludeNames = new String[]{"AgentService.ini", "ComProxy.ini", "Comproxy.sh", "logs", "ComProxyUpdater.jar"};
    private static String[] winCmdEncoding = new String[]{"CP866", "CP850", "CP1252", "UTF-8"};

    public ClientUpdater(String homePath) {
        ClientUpdater.homePath = homePath;
        excludeFiles.addAll(Arrays.asList(excludeNames));
    }

    public String[] updateFiles(String archiveName) {
        this.archiveName = archiveName;
        return this.updateFiles(UnzipUtil.subFolderUnZip(archiveName, homePath));
    }

    private String[] updateFiles(String[] jarNames) {
        String[] resultData;
        if (UpdaterUtils.isLinux()) {
            excludeFiles.add("KSL.exe");
            resultData = ClientUpdater.stopComProxyAndAgentNix();
        } else {
            excludeFiles.add("KslCo");
            resultData = ClientUpdater.stopComProxyAndAgentWin();
        }
        if (resultData[0] != null) {
            return resultData;
        }
        if (jarNames.length == 0) {
            resultData[0] = "ERROR";
            resultData[1] = "1";
            resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u0418\u0417\u0412\u041b\u0415\u0427\u0415\u041d\u0418\u042f \u0424\u0410\u0419\u041b\u041e\u0412";
            return resultData;
        }
        if (UpdaterUtils.isTinyCoreOrUbuntu()) {
            resultData = this.updateTinyCoreFile(jarNames);
        } else {
            for (String jarName : jarNames) {
                LOG.info(" -- File {} --", (Object)jarName);
                if (excludeFiles.contains(jarName)) {
                    LOG.error(" Skip File {} ", (Object)jarName);
                    continue;
                }
                resultData = this.updateOrInsertFile(jarName);
                if (resultData[0] == "SUCCESS") continue;
                this.deleteClientUpdateDataAndDir();
                return resultData;
            }
        }
        this.deleteClientUpdateDataAndDir();
        return resultData;
    }

    private String[] updateTinyCoreFile(String[] jarNames) {
        LOG.error("Update files for TinyCore/Ubuntu");
        String[] resultData = new String[3];
        for (String jarName : jarNames) {
            LOG.info(" -- File {} --", (Object)jarName);
            if (excludeFiles.contains(jarName) || jarName.equalsIgnoreCase("KSL.exe")) {
                LOG.error(" Skip File {} ", (Object)jarName);
                continue;
            }
            try {
                if (jarName.endsWith(".tcz") | jarName.endsWith(".md5.txt") | jarName.endsWith(".tcz.dep")) {
                    if (this.updateTczFile(jarName)) continue;
                    throw new Exception("Error updateFiles file " + jarName);
                }
                File localUserFile = new File(localServicePath + File.separator + jarName);
                File newFile = new File(servicePath + File.separator + UnzipUtil.UPDATE_DATA_FOLDER + File.separator + jarName);
                if (localUserFile.exists()) {
                    LOG.error("Exist file {}", (Object)localUserFile.getAbsoluteFile());
                    if (DeleteFileThread.deleteFile(localUserFile)) {
                        if (!ClientUpdater.copyFile(newFile, localUserFile)) {
                            LOG.error("Can not replace file {}", (Object)localUserFile);
                            resultData[0] = "ERROR";
                            resultData[1] = "1";
                            resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u041a\u041e\u041f\u0418\u0420\u041e\u0412\u0410\u041d\u0418\u042f \u0424\u0410\u0419\u041b\u0410 : " + jarName;
                            return resultData;
                        }
                        LOG.error("Copy file is successful {}", (Object)localUserFile);
                        continue;
                    }
                    LOG.error("Can not delete file {}", (Object)localUserFile);
                    resultData[0] = "ERROR";
                    resultData[1] = "1";
                    resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u0423\u0414\u0410\u041b\u0415\u041d\u0418\u042f \u0424\u0410\u0419\u041b\u0410 : " + jarName;
                    return resultData;
                }
                LOG.error("Not exist file {}", (Object)localUserFile.getAbsoluteFile());
                if (localUserFile.getParentFile() != null && !localUserFile.getParentFile().exists()) {
                    localUserFile.getParentFile().mkdir();
                }
                if (ClientUpdater.copyFile(newFile, localUserFile)) continue;
                LOG.error("Can not copy file {}", (Object)localUserFile);
                resultData[0] = "ERROR";
                resultData[1] = "1";
                resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u041a\u041e\u041f\u0418\u0420\u041e\u0412\u0410\u041d\u0418\u042f \u0424\u0410\u0419\u041b\u0410 : " + jarName;
                return resultData;
            }
            catch (Exception e) {
                LOG.error("Can not updateFiles file {}", (Object)jarName, (Object)e);
                resultData[0] = "ERROR";
                resultData[1] = "1";
                resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u041a\u041e\u041f\u0418\u0420\u041e\u0412\u0410\u041d\u0418\u042f \u0424\u0410\u0419\u041b\u0410 : " + jarName;
                return resultData;
            }
        }
        resultData[0] = "SUCCESS";
        return resultData;
    }

    private void deleteClientUpdateDataAndDir() {
        File dir = new File(homePath + File.separator + UnzipUtil.UPDATE_DATA_FOLDER);
        if (dir.isDirectory()) {
            for (File c : dir.listFiles()) {
                this.delete(c);
            }
        }
        dir.delete();
        File archive = new File(homePath + File.separator + this.archiveName);
        if (archive.exists()) {
            LOG.info("Delete {}", (Object)archive.getAbsolutePath());
            archive.delete();
        }
    }

    private boolean updateTczFile(String fileName) throws IOException {
        LOG.info("Update tcz : {}", (Object)fileName);
        String tcePath = Objects.requireNonNull(UpdaterUtils.getTceDirPath(), "No tce dir");
        tcePath = tcePath + File.separator + "optional" + File.separator;
        File tceDirFile = new File(tcePath + fileName);
        File tceSourceFile = new File(servicePath + File.separator + UnzipUtil.UPDATE_DATA_FOLDER + File.separator + fileName);
        if (!tceDirFile.exists() || DeleteFileThread.deleteFile(tceDirFile)) {
            return ClientUpdater.copyFile(tceSourceFile, tceDirFile);
        }
        return false;
    }

    private void replaceAgentLibsFolders() throws IOException {
        File agentFolderForUpdate = new File(homePath + AGENT_LIBS_FOLDER_NAME);
        File agentFolderWithUpdate = new File(homePath + File.separator + UnzipUtil.UPDATE_DATA_FOLDER + AGENT_LIBS_FOLDER_NAME);
        if (agentFolderWithUpdate.exists()) {
            this.deleteAgentFiles(agentFolderForUpdate);
            ClientUpdater.copyFolder(agentFolderWithUpdate, agentFolderForUpdate);
        }
    }

    private String[] copyNewFile(String fileName) {
        String[] resultData = new String[3];
        String pathForNewFile = fileName.substring(fileName.indexOf(File.separator + UnzipUtil.UPDATE_DATA_FOLDER + File.separator));
        File fileForUpdate = new File(homePath + pathForNewFile);
        File fileWithUpdate = new File(fileName);
        this.makeTreeDirs(fileForUpdate.getParentFile());
        try {
            if (fileWithUpdate.exists()) {
                ClientUpdater.copyFile(fileWithUpdate, fileForUpdate);
            }
        }
        catch (Exception e) {
            LOG.error("Can not updateFiles agent folder");
            resultData[0] = "ERROR";
            resultData[1] = "1";
            resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u041a\u041e\u041f\u0418\u0420\u041e\u0412\u0410\u041d\u0418\u042f \u0424\u0410\u0419\u041b\u0410 : " + fileForUpdate;
            return resultData;
        }
        resultData[0] = "SUCCESS";
        return resultData;
    }

    private void delete(File file) {
        File[] fileList = file.listFiles();
        if (fileList != null) {
            for (File childFile : file.listFiles()) {
                if (childFile.isDirectory()) {
                    this.delete(childFile);
                } else {
                    childFile.delete();
                }
                file.delete();
            }
        } else {
            file.delete();
        }
    }

    private void deleteAgentFiles(File file) {
        File[] fileList;
        for (File f : fileList = file.listFiles()) {
            File currentFile = new File(file.getAbsolutePath(), f.getName());
            currentFile.delete();
        }
    }

    public static void copyFolder(File src, File dest) throws IOException {
        String[] files = src.list();
        if (files != null) {
            for (String file : files) {
                int length;
                FileInputStream in = new FileInputStream(src + File.separator + file);
                FileOutputStream out = new FileOutputStream(dest + File.separator + file);
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, length);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
                LOG.info("Copy {}", (Object)dest.getAbsolutePath());
            }
        }
    }

    private String[] updateOrInsertFile(String newFileName) {
        String[] resultData = new String[3];
        try {
            LOG.info("Start updateFiles file {}", (Object)newFileName);
            File homeDir = new File(homePath);
            File newFile = new File(homeDir.getAbsolutePath() + File.separator + UnzipUtil.UPDATE_DATA_FOLDER + File.separator + newFileName);
            oldFilePath = homeDir.getAbsolutePath() + File.separator + newFileName;
            newFilePath = newFile.getAbsolutePath();
            if (!newFile.exists()) {
                LOG.info("New file is not exist {}", (Object)newFile.getAbsoluteFile());
                resultData[0] = "";
                resultData[1] = "";
                resultData[2] = "";
                return resultData;
            }
            File oldFile = new File(oldFilePath);
            LOG.info("New file Path : " + newFilePath);
            if (oldFile.exists()) {
                LOG.info("Old file Path : " + oldFilePath);
                File oldVerisonDir = new File(homeDir.getAbsolutePath() + File.separator + "oldVersion");
                oldVerisonDir.mkdir();
                backupOldPath = oldVerisonDir.getAbsolutePath() + File.separator + "old_" + newFileName;
                LOG.info("Old file directory path : " + backupOldPath);
                File backupFile = new File(backupOldPath);
                try {
                    ClientUpdater.copyFile(oldFile, backupFile);
                }
                catch (IOException e) {
                    LOG.error("Error {}", e);
                    resultData[0] = "ERROR";
                    resultData[1] = "1";
                    resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u041a\u041e\u041f\u0418\u0420\u041e\u0412\u0410\u041d\u0418\u042f \u0424\u0410\u0419\u041b\u0410 : " + oldFile.getName();
                    return resultData;
                }
            }
            if (!comProxyIsStopped && !UpdaterUtils.isLinux() && (resultData = this.waitStopServices())[0] != null) {
                return resultData;
            }
            resultData = oldFile.exists() ? this.changeFile(new File(newFilePath), new File(oldFilePath)) : this.copyNewFile(newFilePath);
        }
        catch (Throwable tw) {
            LOG.error(tw.getMessage() + " " + tw.getLocalizedMessage());
        }
        return resultData;
    }

    private String[] waitStopServices() throws InterruptedException {
        String[] resultData = ClientUpdater.stopComProxyAndAgentWin();
        if (resultData[0] != null) {
            return resultData;
        }
        Thread.sleep(15000L);
        return resultData;
    }

    private String[] changeFile(File newFile, File oldFile) {
        String[] resultData = new String[3];
        ChangeFileThread renameFileThread = new ChangeFileThread(newFile, oldFile);
        renameFileThread.start();
        long timePoint = System.currentTimeMillis();
        while (renameFileThread.isAlive()) {
            if (timePoint + 30000L >= System.currentTimeMillis()) continue;
            renameFileThread.interrupt();
            LOG.error("Time out error delete file");
            resultData[0] = "ERROR";
            resultData[1] = "1";
            resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u041e\u0411\u041d\u041e\u0412\u041b\u0415\u041d\u0418\u042f \u0424\u0410\u0419\u041b\u0410 : " + newFile.getName();
            return resultData;
        }
        LOG.info("updateFiles successful");
        try {
            this.replaceAgentLibsFolders();
        }
        catch (IOException e) {
            LOG.error("Can not updateFiles agent folder");
            resultData[0] = "ERROR";
            resultData[1] = "1";
            resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u041e\u0411\u041d\u041e\u0412\u041b\u0415\u041d\u0418\u042f \u0424\u0410\u0419\u041b\u0410 : " + newFile.getName();
            return resultData;
        }
        resultData[0] = "SUCCESS";
        return resultData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File sourceFile, File destFile) throws IOException {
        AbstractInterruptibleChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            LOG.info("Try Copy {} size {} to {}", sourceFile.getAbsolutePath(), ((FileChannel)source).size(), destFile.getAbsolutePath());
            ((FileChannel)destination).transferFrom((ReadableByteChannel)((Object)source), 0L, ((FileChannel)source).size());
            LOG.info("Copy " + sourceFile.getAbsolutePath() + " to " + destFile.getAbsolutePath() + " successful");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Error copy {} to {} {}", sourceFile.getAbsolutePath(), destFile.getAbsolutePath(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public File makeTreeDirs(File dirFile) {
        if (!dirFile.exists()) {
            File parentDirFile = dirFile.getParentFile();
            if (parentDirFile.exists()) {
                dirFile.mkdir();
                return dirFile;
            }
            this.makeTreeDirs(parentDirFile);
            dirFile.mkdir();
            return dirFile;
        }
        return dirFile;
    }

    private static void stopComProxyAndAgentWinByNet(String encoding) {
        LOG.info("Execute {}", (Object)"net stop ComProxy");
        try {
            Process process = Runtime.getRuntime().exec("net stop ComProxy");
            String line = "";
            BufferedInputStream bis = new BufferedInputStream(process.getInputStream());
            int size = 0;
            while ((size = bis.available()) > 0) {
                byte[] byteLine = new byte[size];
                bis.read(byteLine);
                line = new String(byteLine, encoding);
                LOG.info(line);
            }
            bis.close();
            process.waitFor();
        }
        catch (Exception e) {
            LOG.error("Error stop ComProxy by NET {}", e);
        }
    }

    private static void stopComProxyAndAgentWinBySC(String encoding) {
        LOG.info("Execute {}", (Object)"sc stop ComProxy");
        try {
            String[] script = new String[]{"cmd.exe", "/c", "sc", "stop", "ComProxy"};
            Process process = Runtime.getRuntime().exec(script);
            BufferedInputStream bis = new BufferedInputStream(process.getInputStream());
            int size = 0;
            String line = "";
            while ((size = bis.available()) > 0) {
                byte[] byteLine = new byte[size];
                bis.read(byteLine);
                line = new String(byteLine, encoding);
                LOG.info(line);
            }
            bis.close();
            process.waitFor();
        }
        catch (Exception e) {
            LOG.error("Error stop ComProxy by SC {}", e);
        }
    }

    public static String[] stopComProxyAndAgentWin() {
        String[] resultData = new String[3];
        int attemptBorder = 4;
        try {
            LOG.info("Stopping ComProxy and Agent on Windows");
            String encoding = ClientUpdater.getCmdEncoding();
            ClientUpdater.sendStopComProxy();
            LOG.info("Execute {}", (Object)"sc stop ComProxy");
            ClientUpdater.stopComProxyAndAgentWinByNet(encoding);
            for (int attempt = 0; ClientUpdater.isComProxyRunning() && attempt < attemptBorder; ++attempt) {
                ClientUpdater.stopComProxyAndAgentWinBySC(encoding);
                Thread.sleep(2000L);
            }
            if (ClientUpdater.isComProxyRunning()) {
                throw new Exception("ComProxy is not stopped");
            }
            comProxyIsStopped = true;
            LOG.info("Stop ComProxy successful");
        }
        catch (Exception e) {
            LOG.error("Error stop ComProxy " + e);
            resultData[0] = "ERROR";
            resultData[1] = "1";
            resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u041e\u0421\u0422\u0410\u041d\u041e\u0412\u041a\u0418 \u0421\u041b\u0423\u0416\u0411\u042b COMPROXY";
        }
        return resultData;
    }

    private static void sendStopComProxy() {
        try {
            String inputLine;
            LOG.info("Send stop ComProxy ...");
            String url = "http://127.0.0.1:5321/stopMonitor& HTTP";
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            LOG.info("Send {} {} {}", url, connection.getRequestMethod(), connection.getRequestProperties());
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setDoOutput(true);
            connection.connect();
            OutputStream os = connection.getOutputStream();
            os.flush();
            os.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            LOG.info("Send stop response {}", (Object)response.toString());
            LOG.info("Finish send stop ComProxy");
        }
        catch (Throwable e) {
            LOG.error("Error send stop ComProxy {}", (Object)e.getMessage());
        }
    }

    private static String getWindowsCmdEncoding() throws IOException, InterruptedException {
        String[] script = new String[]{"cmd.exe", "/c", "chcp"};
        LOG.info("Execute {}", (Object)"cmd.exe /c chcp");
        Process process = Runtime.getRuntime().exec(script);
        String line = "";
        String encoding = "";
        BufferedInputStream bis = new BufferedInputStream(process.getInputStream());
        int size = 0;
        while ((size = bis.available()) > 0) {
            byte[] byteLine = new byte[size];
            bis.read(byteLine);
            line = new String(byteLine);
            encoding = line.substring(line.lastIndexOf(": ") + 2).trim();
            LOG.info("WindowsCmdEncoding : {}", (Object)encoding);
        }
        process.waitFor();
        return encoding;
    }

    private static String getCmdEncoding() {
        String cmdEncodingForRead = "cp866";
        try {
            String currentCmdEncoding = ClientUpdater.getWindowsCmdEncoding();
            for (String suppurtEncoding : winCmdEncoding) {
                if (!suppurtEncoding.contains(currentCmdEncoding)) continue;
                cmdEncodingForRead = suppurtEncoding;
            }
            LOG.info("Set Cmd Encoding : {}", (Object)cmdEncodingForRead);
        }
        catch (Exception e) {
            LOG.error("Error get Encoding {}", e);
        }
        return cmdEncodingForRead;
    }

    private static boolean isComProxyRunning() throws InterruptedException, IOException {
        LOG.info("Check isComProxyRunning");
        String[] script = new String[]{"cmd.exe", "/c", "sc", "query", "ComProxy", "|", "find", "/C", "\"RUNNING\""};
        Process process = Runtime.getRuntime().exec(script);
        BufferedReader bir = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = bir.readLine();
        if (line != null) {
            LOG.info("ComProxy is running : " + "1".equals(line));
            if (line.equals("1")) {
                process.waitFor();
                return true;
            }
            process.waitFor();
            return false;
        }
        return false;
    }

    public static String[] stopComProxyAndAgentWinDreamkas() {
        String[] resultData = new String[3];
        try {
            LOG.info("Stopping ComProxy and Agent");
            Process process = Runtime.getRuntime().exec("net stop ComProxy");
            process.waitFor();
            comProxyIsStopped = true;
            LOG.info("Stop ComProxy successful");
        }
        catch (IOException e) {
            LOG.error("Error stop ComProxy " + e.getMessage());
            resultData[0] = "ERROR";
            resultData[1] = "1";
            resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u041e\u0421\u0422\u0410\u041d\u041e\u0412\u041a\u0418 \u0421\u041b\u0423\u0416\u0411\u042b COMPROXY";
        }
        catch (InterruptedException e1) {
            LOG.error("Error interrupt stop ComProxy " + e1.getMessage());
            LOG.error("Error stop ComProxy " + e1.getMessage());
            resultData[0] = "ERROR";
            resultData[1] = "1";
            resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u041e\u0421\u0422\u0410\u041d\u041e\u0412\u041a\u0418 \u0421\u041b\u0423\u0416\u0411\u042b COMPROXY";
        }
        return resultData;
    }

    public static String[] stopComProxyAndAgentNix() {
        String[] resultData = new String[3];
        try {
            if (UpdaterUtils.isTinyCoreOrUbuntu()) {
                LOG.info("Stopping ComProxy and Agent on Linux TC");
                String[] commandForRun = new String[]{"sudo", servicePath + "/" + serviceName, "stop_srv"};
                Runtime.getRuntime().exec(commandForRun).waitFor();
            } else {
                LOG.info("Stopping ComProxy and Agent on Linux");
                String[] commandForRun = new String[]{"sudo", "bash", "/etc/init.d/comproxy", "stop", "srv"};
                Runtime.getRuntime().exec(commandForRun).waitFor();
            }
            comProxyIsStopped = true;
            LOG.info("Stop ComProxy successful");
        }
        catch (IOException e) {
            LOG.error("Error stop ComProxy " + e.getMessage());
            resultData[0] = "ERROR";
            resultData[1] = "1";
            resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u041e\u0421\u0422\u0410\u041d\u041e\u0412\u041a\u0418 \u0421\u041b\u0423\u0416\u0411\u042b COMPROXY";
        }
        catch (InterruptedException e1) {
            LOG.error("Error interrupt stop ComProxy " + e1.getMessage());
            LOG.error("Error stop ComProxy " + e1.getMessage());
            resultData[0] = "ERROR";
            resultData[1] = "1";
            resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u041e\u0421\u0422\u0410\u041d\u041e\u0412\u041a\u0418 \u0421\u041b\u0423\u0416\u0411\u042b COMPROXY";
        }
        return resultData;
    }

    private void stopAgent(String PID) throws IOException {
        String cmd = "taskkill /F /PID " + PID;
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            throw new IOException("Error Stop Agent");
        }
    }

    public void startComProxyAndAgent() {
        if (UpdaterUtils.isLinux()) {
            this.startComProxyAndAgentNix();
        } else {
            this.startComProxyAndAgentWin();
        }
    }

    public void startComProxyAndAgentWin() {
        try {
            LOG.info("Starting ComProxy and Agent");
            Process process = Runtime.getRuntime().exec("net start ComProxy");
            process.waitFor();
            LOG.info("Start ComProxy and Agent successful");
        }
        catch (IOException e) {
            LOG.error("Error start ComProxy and Agent " + e.getMessage());
        }
        catch (InterruptedException e1) {
            LOG.error("Error interrupt start ComProxy and Agent " + e1.getMessage());
        }
    }

    public void startComProxyAndAgentNix() {
        try {
            if (UpdaterUtils.isTinyCoreOrUbuntu()) {
                LOG.info("Starting ComProxy and Agent on Linux TC");
                String[] commandForRun = new String[]{"sudo", servicePath + "/" + serviceName, "start"};
                Runtime.getRuntime().exec(commandForRun).waitFor();
            } else {
                LOG.info("Starting ComProxy and Agent on Linux");
                String[] commandForRun = new String[]{"sudo", "bash", "/etc/init.d/comproxy", "start"};
                Runtime.getRuntime().exec(commandForRun).waitFor();
            }
            LOG.info("Start ComProxy and Agent successful");
        }
        catch (IOException e) {
            LOG.error("Error start ComProxy and Agent " + e.getMessage());
        }
        catch (InterruptedException e1) {
            LOG.error("Error interrupt start ComProxy and Agent " + e1.getMessage());
        }
    }
}

