/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.softwareUpdater;

import com.company.updater.softwareUpdater.ClientUpdater;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeFileThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeFileThread.class);
    private File srcFileNew;
    private File srcFileOld;

    public ChangeFileThread(File srcFileNew, File srcFileOld) {
        this.srcFileNew = srcFileNew;
        this.srcFileOld = srcFileOld;
    }

    @Override
    public void run() {
        LOG.info(" + ChangeFileThread start");
        LOG.info(" Try replace old {} on new {}", (Object)this.srcFileOld.getAbsoluteFile(), (Object)this.srcFileNew.getAbsoluteFile());
        while (!Thread.interrupted()) {
            try {
                if (!this.srcFileOld.delete()) continue;
                LOG.info("Delete successful! path new file is {}", (Object)this.srcFileNew.getAbsoluteFile());
                boolean result = false;
                result = ClientUpdater.copyFile(this.srcFileNew, this.srcFileOld);
                if (!result) continue;
                LOG.info("result change file is {}", (Object)result);
                break;
            }
            catch (Exception e) {
                LOG.error("Error in ChangeFileThread {}", (Object)e.getMessage());
            }
        }
        LOG.info(" - ChangeFileThread end");
    }
}

