/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.legacy;

import com.company.updater.TaskResult;
import com.company.updater.TaskResultWithErrorData;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskResultWriter {
    private static final Logger LOG = LoggerFactory.getLogger(TaskResultWriter.class);
    private static final String FILE_EXTENSION = ".tsk";
    private static final String TASK_DIRECTORY = "tasks";
    private String TASK_DATA_NAME = "_data-";
    private String TASK_RESULT_NAME = "_result-";
    private String GUI_RESULT_NAME = "_gui";
    private String DATA_FILENAME = "";
    private BufferedReader br = null;
    private FileReader fr = null;
    private Gson gson = null;
    private TaskResult taskData = null;

    public void writeTaskResult(String fileNameStart, String result, String errorCode, String errorMsg) {
        LOG.info("Start write result task - result : " + result + " errorCode : " + errorCode + " errorMsg : " + errorMsg + " for " + fileNameStart);
        this.writeTaskResultForGUI(fileNameStart, result);
        this.TASK_DATA_NAME = fileNameStart + this.TASK_DATA_NAME;
        this.gson = new Gson();
        this.taskData = this.readData();
        if (this.taskData != null) {
            LOG.info("Read task : Task_id : {}  result : {} ", (Object)this.taskData.getTask_id(), (Object)this.taskData.getResult());
            this.taskData.setResult(result);
            if (errorCode != null && !errorCode.equals("")) {
                if (errorMsg == null) {
                    errorMsg = "";
                }
                this.taskData = new TaskResultWithErrorData(null, this.taskData.getTask_id(), this.taskData.getResult(), errorCode, errorMsg);
            }
            LOG.info("writeResult:");
            this.writeResult(this.taskData, fileNameStart);
        } else {
            LOG.info("Task data is empty.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTaskResultForGUI(String fileNameStart, String result) {
        block13: {
            LOG.info("Start create result for GUI : file name {}  result {}", (Object)fileNameStart, (Object)result);
            String fileName = fileNameStart + this.GUI_RESULT_NAME + FILE_EXTENSION;
            BufferedWriter output = null;
            try {
                File file = new File(new File("").getAbsolutePath() + "\\" + TASK_DIRECTORY + "\\" + fileName);
                file.createNewFile();
                output = new BufferedWriter(new FileWriter(file));
                output.write(result);
                if (file.exists()) {
                    LOG.info("End create result for GUI, result : {}", (Object)result);
                    break block13;
                }
                throw new IOException("File is not created");
            }
            catch (IOException e) {
                String error = "Error create file " + e.getMessage();
                LOG.error(error);
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        LOG.error("Error close file {}", (Object)e.getMessage());
                    }
                }
            }
        }
    }

    private File getTaskFile() {
        File result = null;
        File taskdir = new File(new File("").getAbsolutePath() + "\\" + TASK_DIRECTORY);
        if (taskdir.exists()) {
            File[] foundFiles = taskdir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(TaskResultWriter.this.TASK_DATA_NAME);
                }
            });
            int taskNumber = 0;
            for (File file : foundFiles) {
                int tmpTasknumber = this.getTaskNumber(file);
                if (tmpTasknumber <= taskNumber) continue;
                taskNumber = tmpTasknumber;
            }
            if (taskNumber != 0) {
                result = new File(taskdir.getAbsolutePath() + "\\" + this.TASK_DATA_NAME + taskNumber + FILE_EXTENSION);
                if (result.exists()) {
                    return result;
                }
                result = null;
            }
        }
        return result;
    }

    private int getTaskNumber(File file) {
        String fileName = file.getName();
        String data = "0";
        try {
            int i = fileName.indexOf("-") + 1;
            int j = fileName.indexOf(".");
            data = fileName.substring(i, j);
        }
        catch (Exception e) {
            LOG.error("Error read task number {} {}", (Object)e.getMessage());
        }
        return Integer.valueOf(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult readData() {
        LOG.info("Start read task data");
        TaskResult taskResult = null;
        File taskfile = this.getTaskFile();
        if (taskfile != null && taskfile.exists()) {
            this.DATA_FILENAME = taskfile.getAbsolutePath();
            try {
                String sCurrentLine;
                this.br = new BufferedReader(new FileReader(this.DATA_FILENAME));
                StringBuilder sb = new StringBuilder();
                while ((sCurrentLine = this.br.readLine()) != null) {
                    sb.append(sCurrentLine);
                }
                LOG.info("Read task data data : {}", (Object)sb.toString());
                taskResult = this.gson.fromJson(sb.toString(), TaskResult.class);
                LOG.info("End read task data");
                TaskResult taskResult2 = taskResult;
                return taskResult2;
            }
            catch (IOException e) {
                LOG.error("Read task data error {}", e);
            }
            finally {
                try {
                    if (this.br != null) {
                        this.br.close();
                    }
                    if (this.fr != null) {
                        this.fr.close();
                    }
                }
                catch (IOException ex) {
                    LOG.error("Close file error {}", ex);
                }
            }
        }
        LOG.info("Task don't have task file");
        return taskResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResult(TaskResult taskResult, String fileNameStart) {
        LOG.info("Start write task result ");
        BufferedWriter output = null;
        this.TASK_RESULT_NAME = fileNameStart + this.TASK_RESULT_NAME;
        String jsonTaskResult = this.gson.toJson(taskResult);
        try {
            File file = new File(new File("").getAbsolutePath() + "\\" + TASK_DIRECTORY + "\\" + this.TASK_RESULT_NAME + taskResult.getTask_id() + FILE_EXTENSION);
            output = new BufferedWriter(new FileWriter(file));
            output.write(jsonTaskResult);
            LOG.info("End write task result data");
        }
        catch (IOException e) {
            String error = "Error write file " + e.getMessage();
            LOG.error(error);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOG.error("Error close file {}", (Object)e.getMessage());
                }
            }
        }
    }
}

