/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.firmwareUpdater;

import com.company.updater.PiritProlocol.ByteArrayLog;
import com.company.updater.PiritProlocol.ComPacket;
import com.company.updater.PiritProlocol.ComPacketReader;
import com.company.updater.PiritProlocol.DataTimeKKT;
import com.company.updater.PiritProlocol.PackageReader;
import com.company.updater.PiritProlocol.SerialWriterThread;
import com.company.updater.UpdaterUtils;
import com.company.updater.firmwareUpdater.BaudRate;
import com.company.updater.firmwareUpdater.BiosMode;
import com.company.updater.firmwareUpdater.DeviceState;
import com.company.updater.firmwareUpdater.FlashBios;
import com.company.updater.firmwareUpdater.FlashBiosException;
import com.company.updater.firmwareUpdater.PortWrapper;
import com.company.updater.softwareUpdater.ClientUpdater;
import java.io.File;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KKTUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(ClientUpdater.class);
    public static final String KSL_NAME_WIN = "KSL.exe";
    public static final String KSL_NAME_NIX = "KslCo";
    public static BaudRate baudRate115200 = BaudRate.B115200;
    public static BaudRate baudRate57600 = BaudRate.B57600;
    public static BaudRate baudRate19200 = BaudRate.B19200;
    private static long kktStartTimeTimeOut = 8000L;
    private final FlashBios flashBios;
    private String currentDir = "";
    private String portName = "";

    public KKTUpdater(String homePath) {
        this.currentDir = homePath;
        this.flashBios = new FlashBios();
    }

    public String[] update(String firmwareName, String portNum) {
        String[] result;
        this.portName = portNum;
        long timeOut = 5000L;
        if (this.isLinux()) {
            result = ClientUpdater.stopComProxyAndAgentNix();
        } else {
            timeOut = 3000L;
            result = ClientUpdater.stopComProxyAndAgentWin();
        }
        if (result[0] != null) {
            return result;
        }
        try {
            result = this.updateFw(firmwareName, portNum, timeOut);
            this.waitConnectionWithKKT();
            this.startWorkKKT();
        }
        catch (FlashBiosException e) {
            result[0] = "ERROR";
            result[1] = "1";
            result[2] = e.getMessage();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            result[0] = "ERROR";
            result[1] = "1";
            result[2] = "\u041e\u0411\u041d\u041e\u0412\u041b\u0415\u041d\u0418\u0415 \u041f\u041e \u041a\u041a\u0422 \u041f\u0420\u0415\u0420\u0412\u0410\u041d\u041e";
        }
        return result;
    }

    private boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    private void waitConnectionWithKKT() {
        long kktStartTime = System.currentTimeMillis();
        while (!this.pingKKT(this.portName) && kktStartTime + kktStartTimeTimeOut > System.currentTimeMillis()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized ComPacket invokeCommandKKT(String portName, int cmd, String ... params) {
        SerialPort serialPort = new SerialPort(portName);
        ComPacketReader comPacketReader = new ComPacketReader();
        try {
            PackageReader packageReader = new PackageReader(false, comPacketReader);
            serialPort.openPort();
            serialPort.setParams(57600, 8, 1, 0);
            SerialWriterThread serialWriterThread = new SerialWriterThread(serialPort, UpdaterUtils.makeCommand(cmd, (byte)1, params));
            serialWriterThread.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (serialWriterThread.isAlive()) {
                serialWriterThread.interrupt();
                ComPacket e = null;
                return e;
            }
            long timePoint = System.currentTimeMillis();
            while (comPacketReader.getResult() == null && timePoint + kktStartTimeTimeOut > System.currentTimeMillis()) {
                byte[] data = serialPort.readBytes();
                if (data != null && data.length > 0) {
                    LOG.info(" read --> {}", (Object)new ByteArrayLog(data, data.length));
                    packageReader.write(data, data.length);
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            LOG.info(" read comPacket --> {}", (Object)comPacketReader.getResult());
            ComPacket comPacket = comPacketReader.getResult();
            return comPacket;
        }
        catch (Exception e) {
            LOG.error("Error invokeCommandKKT {}", e);
            ComPacket comPacket = null;
            return comPacket;
        }
        finally {
            try {
                serialPort.closePort();
            }
            catch (SerialPortException e) {
                LOG.error("Error closePort {}", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean pingKKT(String portName) {
        SerialPort serialPort = new SerialPort(portName);
        ComPacketReader comPacketReader = new ComPacketReader();
        try {
            PackageReader packageReader = new PackageReader(false, comPacketReader);
            serialPort.openPort();
            serialPort.setParams(57600, 8, 1, 0);
            SerialWriterThread serialWriterThread = new SerialWriterThread(serialPort, new byte[]{5});
            serialWriterThread.start();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (serialWriterThread.isAlive()) {
                serialWriterThread.interrupt();
                boolean e = false;
                return e;
            }
            byte[] data = serialPort.readBytes();
            if (data != null && data.length > 0) {
                LOG.info(" read --> {}", (Object)new ByteArrayLog(data, data.length));
                packageReader.write(data, data.length);
                boolean bl = comPacketReader.getResult().testCommand((byte)6);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Error pingKKT {}", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (serialPort.isOpened()) {
                    serialPort.closePort();
                }
            }
            catch (SerialPortException e) {
                LOG.error("Error closePort {}", e);
            }
        }
    }

    private DataTimeKKT getDataTimeKKT() {
        if (this.portName != null) {
            try {
                LOG.info("Make getDataTimeKKT");
                ComPacket dataTimePacket = KKTUpdater.invokeCommandKKT(this.portName, 19, "");
                if (dataTimePacket != null) {
                    return new DataTimeKKT(dataTimePacket.getPacketValueByIndex(0), dataTimePacket.getPacketValueByIndex(1));
                }
            }
            catch (Exception e) {
                LOG.error("Error getDataTimeKKT {}", e);
            }
        }
        return null;
    }

    private void startWorkKKT() {
        if (this.portName != null) {
            try {
                LOG.info("Make Start Work KKT");
                DataTimeKKT dataTimeKKT = this.getDataTimeKKT();
                if (dataTimeKKT == null) {
                    return;
                }
                KKTUpdater.invokeCommandKKT(this.portName, 16, dataTimeKKT.getDate(), dataTimeKKT.getTime());
            }
            catch (Exception e) {
                LOG.error("Error startWorkKKT", e);
            }
        }
    }

    private String[] updateFw(String fwName, String portNum, long millis) throws InterruptedException, FlashBiosException {
        LOG.info("Starting FW update process");
        File biosFile = new File(this.getFirmWareName(fwName));
        byte[][] biosParts = this.flashBios.loadBiosFile(biosFile);
        String[] resultData = new String[3];
        LOG.info("First attempt on {}", (Object)baudRate115200);
        int exitStatus = this.loadFirmWare(biosParts, portNum, baudRate115200);
        if (exitStatus == 1) {
            Thread.sleep(millis);
            LOG.info("Second attempt on {}", (Object)baudRate115200);
            exitStatus = this.loadFirmWare(biosParts, portNum, baudRate115200);
        }
        if (exitStatus == 1) {
            Thread.sleep(millis);
            LOG.info("Third attempt on {}", (Object)baudRate57600);
            exitStatus = this.loadFirmWare(biosParts, portNum, baudRate57600);
        }
        if (exitStatus == 1) {
            Thread.sleep(millis);
            LOG.info("Last attempt on {}", (Object)baudRate19200);
            exitStatus = this.loadFirmWare(biosParts, portNum, baudRate19200);
        }
        LOG.info("FW process finished. Exit code: {}", (Object)exitStatus);
        if (exitStatus == 0) {
            resultData[0] = "SUCCESS";
            resultData[1] = "";
            resultData[2] = "";
            return resultData;
        }
        resultData[0] = "ERROR";
        resultData[1] = "1";
        resultData[2] = "\u041e\u0428\u0418\u0411\u041a\u0410 \u0417\u0410\u0413\u0420\u0423\u0417\u041a\u0418 \u041f\u041e \u0424\u0418\u0421\u041a\u0410\u041b\u042c\u041d\u041e\u0413\u041e \u0420\u0415\u0413\u0418\u0421\u0422\u0420\u0410\u0422\u041e\u0420\u0410";
        return resultData;
    }

    private String getFirmWareName(String firmWareName) {
        if (this.isLinux()) {
            return this.currentDir + firmWareName;
        }
        return firmWareName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int loadFirmWare(byte[][] biosParts, String portNum, BaudRate bootLoaderBaudRate) throws FlashBiosException {
        try {
            if (!this.flashBios.findAndPrepareToBoot(portNum, bootLoaderBaudRate)) {
                return 1;
            }
            this.flashBios.flashBios(portNum, bootLoaderBaudRate, biosParts);
            LOG.debug("Finding device after flashing...");
            Thread.sleep(3000L);
            try (PortWrapper portWrapper = this.flashBios.connectTo(this.portName, 10, 3000);){
                DeviceState deviceState = this.flashBios.foundOutDeviceAll(portWrapper);
                if (deviceState != null) {
                    if (deviceState.getMode() == BiosMode.NORMAL) {
                        int n = 0;
                        return n;
                    }
                    LOG.error("Device in BOOTLOADER mode after flashing. Will try flashing again");
                    int n = 1;
                    return n;
                }
            }
            DeviceState deviceState = this.flashBios.foundOutDeviceAll(this.portName);
            if (deviceState == null) {
                LOG.error("Device not found after flashing");
                throw new FlashBiosException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043f\u043e\u0441\u043b\u0435 \u043f\u0440\u043e\u0448\u0438\u0432\u043a\u0438");
            }
            if (deviceState.getMode() != BiosMode.BOOTLOADER) return 0;
            LOG.error("Device in BOOTLOADER mode after flashing. Will try flashing again");
            return 1;
        }
        catch (FlashBiosException e) {
            LOG.error("Error on load firmware", e);
            return 1;
        }
        catch (Exception e) {
            LOG.error("Error on load firmware", e);
            throw new FlashBiosException("\u041e\u0428\u0418\u0411\u041a\u0410 \u0417\u0410\u0413\u0420\u0423\u0417\u041a\u0418 \u041f\u041e \u0424\u0418\u0421\u041a\u0410\u041b\u042c\u041d\u041e\u0413\u041e \u0420\u0415\u0413\u0418\u0421\u0422\u0420\u0410\u0422\u041e\u0420\u0410", e);
        }
    }

    public static void deleteFirmwarefile(String homePath, String firmawareName) {
        File file = new File(homePath + File.separator + firmawareName);
        if (file.exists()) {
            LOG.info("Try delete firmware file : {}", (Object)firmawareName);
            if (file.delete()) {
                LOG.info("Firmware file deleted");
            } else {
                LOG.info("Can not delete firmware file");
            }
        }
    }
}

