/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class UpdaterUtils {
    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public static boolean isTinyCoreOrUbuntu() {
        return Files.isSymbolicLink(Paths.get("/etc/sysconfig/tcedir", new String[0]));
    }

    public static String getTceDirPath() {
        Path path = Paths.get("/etc/sysconfig/tcedir", new String[0]);
        if (!Files.exists(path, new LinkOption[0]) || !Files.isSymbolicLink(path)) {
            return null;
        }
        try {
            return Files.readSymbolicLink(path).toAbsolutePath().toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static byte[] makeCommand(int command, byte packetId, String ... params) {
        try {
            String commandString = String.format("%02X", command);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(2);
            UpdaterUtils.writePrefix(baos);
            baos.write(("" + (char)packetId).getBytes());
            baos.write(commandString.getBytes());
            if (params != null && params.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (String param : params) {
                    if (sb.length() > 0) {
                        sb.append('\u001c');
                    }
                    sb.append(param);
                }
                baos.write(sb.toString().getBytes());
            }
            baos.write(3);
            baos.write(UpdaterUtils.createCrc(baos.toByteArray()).getBytes());
            return baos.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String bytesToHex(byte[] bytes, int read) {
        String result = null;
        if (bytes != null) {
            result = "";
            for (int j = 0; j < read; ++j) {
                int v = bytes[j] & 0xFF;
                String hex = Integer.toHexString(v);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                result = result + "," + hex;
            }
            if (result.length() > 0) {
                result = result.substring(1, result.length());
            }
        }
        return result;
    }

    public static byte byteCrc(byte[] dataArray) {
        byte newCrc = 0;
        for (int i = 0; i < dataArray.length; ++i) {
            newCrc = (byte)((newCrc ^ dataArray[i]) & 0xFF);
        }
        return newCrc;
    }

    private static void writePrefix(OutputStream os) throws IOException {
        os.write("PIRI".getBytes());
    }

    public static String createCrc(byte[] dataArray) {
        return String.format("%02X", UpdaterUtils.calcCrc(dataArray));
    }

    public static int calcCrc(byte[] dataArray) {
        int newCrc = 0;
        for (int i = 1; i < dataArray.length; ++i) {
            newCrc = (newCrc ^ dataArray[i]) & 0xFF;
        }
        return newCrc;
    }
}

