/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnzipUtil {
    private static final Logger LOG = LoggerFactory.getLogger(UnzipUtil.class);
    public static String UPDATE_DATA_FOLDER = "clientUpdateData";
    public static String AGENT_JAR_NAME = "AgentService.jar";
    public static String AGENT_EXE_NAME = "AgentService.exe";
    public static String COMPROXY_JAR_NAME = "ComProxy.jar";
    public static String JARS_FOR_UPDATE_FOLDER = "\\clientUpdateData";

    public static String[] subFilderUnZip(String archiveName) {
        File out = new File(new File("").getAbsolutePath() + JARS_FOR_UPDATE_FOLDER);
        File source = new File(archiveName);
        return UnzipUtil.subFolderUnZip(out, source, new HashSet<String>(Arrays.asList(AGENT_JAR_NAME, AGENT_EXE_NAME, COMPROXY_JAR_NAME)));
    }

    public static String[] subFolderUnZip(String archiveName, String homePath) {
        return UnzipUtil.subFolderUnZip(archiveName, homePath, Collections.emptySet());
    }

    public static String[] subFolderUnZip(String archiveName, String homePath, Set<String> fileNamesFilter) {
        File out = new File(homePath + File.separator + UPDATE_DATA_FOLDER);
        File source = new File(homePath + File.separator + archiveName);
        return UnzipUtil.subFolderUnZip(out, source, fileNamesFilter);
    }

    public static String[] subFolderUnZip(File out, File source, Set<String> fileNamesFilter) {
        ArrayList<String> fileNames = new ArrayList<String>();
        LOG.info("Try unzip file {}", (Object)source.getAbsolutePath());
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(source));
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                String entryName = entry.getName();
                File file = new File(out.getAbsolutePath(), entryName);
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else {
                    int location;
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] buffer = new byte[409600];
                    long byteCount = 0L;
                    while ((location = zis.read(buffer)) != -1) {
                        bos.write(buffer, 0, location);
                        byteCount += (long)location;
                    }
                    bos.flush();
                    bos.close();
                    if (fileNamesFilter.isEmpty() || fileNamesFilter.contains(entryName)) {
                        fileNames.add(entryName);
                    }
                    LOG.info("Unzip file {} size {} write {}", file.getName(), file.length(), byteCount);
                }
                entry = zis.getNextEntry();
            }
            zis.close();
        }
        catch (IOException e) {
            LOG.error("Error unzip file {}", e);
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }
}

