/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.PiritProlocol;

import java.util.Arrays;

public class TcpHeader {
    private int len;
    private int srcPort;
    private int dstPort;
    private String srcIp;
    private String dstIp;
    private Long seqNo;
    private Long arcNo;
    private byte[] headBody = new byte[40];

    public TcpHeader(byte[] b) {
        System.arraycopy(b, 0, this.headBody, 0, this.headBody.length);
        this.len = this.readInt(b, 2);
        this.srcPort = this.readInt(b, 20);
        this.dstPort = this.readInt(b, 22);
        this.srcIp = this.readIpAddr(b, 12);
        this.dstIp = this.readIpAddr(b, 16);
        this.seqNo = this.readLong(b, 24);
        this.arcNo = this.readLong(b, 28);
    }

    private int readInt(byte[] source, int addr) {
        return (source[addr] & 0xFF) + ((source[addr + 1] & 0xFF) << 8);
    }

    private long readLong(byte[] source, int addr) {
        return (long)(source[addr] & 0xFF) + ((long)(source[addr + 1] & 0xFF) << 8) + (long)((source[addr + 2] & 0xFF) << 16) + (long)((source[addr + 3] & 0xFF) << 24);
    }

    private void writeLong(byte[] source, int addr, long value) {
        source[addr] = (byte)(value & 0xFFL);
        source[addr + 1] = (byte)(value >> 8 & 0xFFL);
        source[addr + 2] = (byte)(value >> 16 & 0xFFL);
        source[addr + 3] = (byte)(value >> 24 & 0xFFL);
    }

    private String readIpAddr(byte[] source, int addr) {
        return "" + (source[addr] & 0xFF) + '.' + (source[addr + 1] & 0xFF) + '.' + (source[addr + 2] & 0xFF) + '.' + (source[addr + 3] & 0xFF);
    }

    public int getLen() {
        return this.len;
    }

    public Long getSeqNo() {
        return this.seqNo;
    }

    public Long getArcNo() {
        return this.arcNo;
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public String getDstIp() {
        return this.dstIp;
    }

    public byte[] getBody() {
        return this.headBody;
    }

    public byte[] asResponce() {
        byte[] result = this.headBody;
        byte[] sourceHost = Arrays.copyOfRange(result, 12, 16);
        byte[] sourcePort = Arrays.copyOfRange(result, 20, 22);
        byte[] destinationHost = Arrays.copyOfRange(result, 16, 20);
        byte[] destinationPort = Arrays.copyOfRange(result, 22, 24);
        System.arraycopy(sourceHost, 0, result, 16, 4);
        System.arraycopy(sourcePort, 0, result, 22, 2);
        System.arraycopy(destinationHost, 0, result, 12, 4);
        System.arraycopy(destinationPort, 0, result, 20, 2);
        this.writeLong(result, 24, 1L);
        this.writeLong(result, 28, 1L);
        return result;
    }

    public String toString() {
        return "TcpHeader{len=" + this.len + ", srcPort=" + this.srcPort + ", dstPort=" + this.dstPort + ", srcIp=" + this.srcIp + ", dstIp=" + this.dstIp + ", seqNo=" + this.seqNo + ", arcNo=" + this.arcNo + '}';
    }
}

