/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater.PiritProlocol;

import com.company.updater.PiritProlocol.ByteArrayLog;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialWriterThread
extends Thread {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    private SerialPort serialPort;
    private String strData;
    private byte[] byteData = null;

    public void setStrData(String data) {
        this.strData = data;
    }

    public void setByteData(byte[] data) {
        this.byteData = data;
    }

    public SerialWriterThread(SerialPort serialPort) {
        this.serialPort = serialPort;
        this.byteData = new byte[0];
    }

    public SerialWriterThread(SerialPort serialPort, byte[] dataToSend) {
        this.serialPort = serialPort;
        this.byteData = dataToSend;
    }

    @Override
    public void run() {
        try {
            this.serialPort.writeBytes(this.byteData);
            this.LOG.info(" send <-- {}", (Object)new ByteArrayLog(this.byteData, this.byteData.length));
        }
        catch (SerialPortException e) {
            try {
                if (this.serialPort.isOpened()) {
                    this.serialPort.closePort();
                }
            }
            catch (SerialPortException e1) {
                this.LOG.error("Error close port {}", (Object)this.serialPort.getPortName());
            }
            finally {
                try {
                    this.serialPort.closePort();
                }
                catch (SerialPortException e1) {
                    this.LOG.error("Error close port {}", (Object)this.serialPort.getPortName());
                }
            }
            Thread.currentThread().interrupt();
        }
    }
}

