/*
 * Decompiled with CFR 0.152.
 */
package com.company.updater;

import com.company.updater.Version;
import com.company.updater.firmwareUpdater.KKTUpdater;
import com.company.updater.logConfig.LogConfig;
import com.company.updater.softwareUpdater.ClientUpdater;
import com.company.updater.softwareUpdater.DeleteFileThread;
import com.company.updater.taskUpdater.UpdaterTaskReader;
import com.company.updater.taskUpdater.UpdaterTaskResultWriter;
import com.company.updater.updaterTasks.UpdateFirmwareTask;
import com.company.updater.updaterTasks.UpdaterTask;
import com.company.updater.updaterTasks.UpdaterTaskType;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static final String PID_KEY = "-PID";
    private static final String UPDATE_TYPE_KEY = "-Type";
    private static final String SOFTWARE_FILE_NAME_KEY = "-Client";
    private static final String FIRMWARE_FILE_NAME_KEY = "-Firmware";
    private static final String PORT_NAME_KEY = "-Port";
    private static final String HOMEPATH_NAME_KEY = "-HomePath";

    public static void main(String[] args) {
        try {
            String[] params = Main.argsResolver(args);
            String homePath = params[5];
            LogConfig.configureLogger(homePath);
            if (params[0] != null) {
                if (params[0].equals("tsk")) {
                    LOG.info("Start update by task. ComProxyUpdater version: {}", (Object)Version.getVersion());
                    UpdaterTaskReader updaterTaskReader = new UpdaterTaskReader(homePath);
                    Main.executeUpdaterTasks(updaterTaskReader.read(), homePath);
                    ClientUpdater clientUpdater = new ClientUpdater(homePath);
                    clientUpdater.startComProxyAndAgent();
                    LOG.info("End update task");
                } else {
                    com.company.updater.legacy.Main.main(args);
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            LOG.error("Error {}", e);
        }
    }

    private static void executeUpdaterTasks(List<UpdaterTask> updaterTaskList, String homePath) {
        UpdaterTaskResultWriter updaterTaskResultWriter = new UpdaterTaskResultWriter(homePath);
        boolean comProxyUpdated = false;
        for (UpdaterTask updaterTask : updaterTaskList) {
            if (updaterTask.getTaskType().equals((Object)UpdaterTaskType.UPDATE_COMPROXY)) {
                String[] resultData;
                if (!comProxyUpdated) {
                    ClientUpdater clientUpdater = new ClientUpdater(homePath);
                    resultData = clientUpdater.updateFiles(updaterTask.getFileName());
                    comProxyUpdated = true;
                } else {
                    resultData = new String[]{"SUCCESS", "", ""};
                }
                updaterTaskResultWriter.addTaskResult(updaterTask, resultData);
                continue;
            }
            if (updaterTask.getTaskType().equals((Object)UpdaterTaskType.UPDATE_FIRMWARE)) {
                UpdateFirmwareTask updateFirmwareTask = (UpdateFirmwareTask)updaterTask;
                KKTUpdater kktUpdater = new KKTUpdater(homePath);
                String[] resultData = kktUpdater.update(updateFirmwareTask.getFileName(), updateFirmwareTask.getPortName());
                updaterTaskResultWriter.addTaskResult(updaterTask, resultData);
                continue;
            }
            updaterTaskResultWriter.addTaskResult(updaterTask, new String[]{"ERROR"});
        }
        updaterTaskResultWriter.writeResults();
        for (UpdaterTask updaterTask : updaterTaskList) {
            if (!updaterTask.getTaskType().equals((Object)UpdaterTaskType.UPDATE_FIRMWARE)) continue;
            KKTUpdater.deleteFirmwarefile(homePath, updaterTask.getFileName());
        }
        UpdaterTaskReader updaterTaskReader = new UpdaterTaskReader(homePath);
        for (File file : updaterTaskReader.getUpdaterTaskFiles()) {
            DeleteFileThread.deleteFile(file);
        }
    }

    private static String[] argsResolver(String[] args) throws Exception {
        String[] result = new String[6];
        for (String arg : args) {
            if (arg.contains(UPDATE_TYPE_KEY)) {
                result[0] = Main.getValue(arg);
                continue;
            }
            if (arg.contains(SOFTWARE_FILE_NAME_KEY)) {
                result[1] = Main.getValue(arg);
                continue;
            }
            if (arg.contains(FIRMWARE_FILE_NAME_KEY)) {
                result[2] = Main.getValue(arg);
                continue;
            }
            if (arg.contains(PORT_NAME_KEY)) {
                result[3] = Main.getValue(arg);
                continue;
            }
            if (arg.contains(PID_KEY)) {
                result[4] = Main.getValue(arg);
                continue;
            }
            if (arg.contains(HOMEPATH_NAME_KEY)) {
                result[5] = Main.getValue(arg);
                String tmpCurrentDir = result[5];
                if (tmpCurrentDir.endsWith(File.separator)) continue;
                result[5] = tmpCurrentDir + File.separator;
                continue;
            }
            if (result[5] != null) continue;
            throw new Exception("Invalid homePath param in -HomePath");
        }
        return result;
    }

    private static String getValue(String value) {
        return value.substring(value.indexOf("=") + 1);
    }
}

