/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.utils.time;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import ru.crystals.utils.time.DurationFormatter;

public class StopTimer {
    static AtomicLong timeTestSupplier;
    private long startTime;

    public StopTimer() {
        this.restart();
    }

    public StopTimer restart() {
        this.startTime = this.getCurrentTime();
        return this;
    }

    private long getCurrentTime() {
        return timeTestSupplier != null ? timeTestSupplier.get() : System.nanoTime();
    }

    public long getElapsedNanos() {
        return this.getCurrentTime() - this.startTime;
    }

    public Duration getElapsed() {
        return Duration.ofNanos(this.getElapsedNanos());
    }

    public String getElapsedTimeAsStringAndRestart() {
        String s = this.getElapsedTimeAsString();
        this.restart();
        return s;
    }

    public String getElapsedTimeAsString() {
        return DurationFormatter.formatDuration(this.getElapsedNanos());
    }

    public String toString() {
        return this.getElapsedTimeAsString();
    }
}

