/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.utils.time;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class DurationFormatter {
    private static final long MILLIS_PER_HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final long MILLIS_PER_MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private static final long MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private static final String ZERO_TIME_AS_STRING = "0:00:00.000";

    public static String formatDuration(Duration durationNanos) {
        if (durationNanos.isZero()) {
            return ZERO_TIME_AS_STRING;
        }
        return DurationFormatter.formatDurationMillis(durationNanos.toNanos());
    }

    public static String formatDuration(long durationNanos) {
        if (durationNanos == 0L) {
            return ZERO_TIME_AS_STRING;
        }
        return DurationFormatter.formatDurationMillis(TimeUnit.NANOSECONDS.toMillis(durationNanos));
    }

    public static String formatDurationMillis(long durationMillis) {
        if (durationMillis == 0L) {
            return ZERO_TIME_AS_STRING;
        }
        long millis = durationMillis;
        int hours = (int)(millis / MILLIS_PER_HOUR);
        int minutes = (int)((millis -= (long)hours * MILLIS_PER_HOUR) / MILLIS_PER_MINUTE);
        int seconds = (int)((millis -= (long)minutes * MILLIS_PER_MINUTE) / MILLIS_PER_SECOND);
        millis -= (long)seconds * MILLIS_PER_SECOND;
        StringBuilder sb = new StringBuilder();
        sb.append(hours).append(":");
        if (minutes < 10) {
            sb.append("0");
        }
        sb.append(minutes).append(":");
        if (seconds < 10) {
            sb.append("0");
        }
        sb.append(seconds).append(".");
        if (millis < 100L) {
            sb.append("0");
            if (millis < 10L) {
                sb.append("0");
            }
        }
        return sb.append(millis).toString();
    }
}

