/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.agent.agentDataTransfer.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class CommandResponse {
    public static final DateTimeFormatter DATE_PATTERN = DateTimeFormatter.ofPattern("ddMMyy");
    public static final DateTimeFormatter TIME_PATTERN = DateTimeFormatter.ofPattern("HHmmss");
    public static final DateTimeFormatter DATE_TIME_PATTERN = DateTimeFormatter.ofPattern("ddMMyyHHmmss");
    public static final String NULL_DATE_VALUE = "000000";
    private final List<String> data;
    private final String errorCode;

    private CommandResponse(String errorCode, List<String> params) {
        this.errorCode = errorCode;
        this.data = Objects.requireNonNull(params);
    }

    public static CommandResponse with(List<String> params) {
        return new CommandResponse(null, params);
    }

    public static CommandResponse with(String params) {
        return new CommandResponse(null, Collections.singletonList(params));
    }

    public static CommandResponse withError(String errorCode) {
        return new CommandResponse(errorCode, Collections.emptyList());
    }

    public List<String> getParams() {
        return this.data;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getString(int index) {
        return this.data.get(index);
    }

    public String getStringSafe(int index) {
        return this.data.size() > index ? this.data.get(index) : null;
    }

    public LocalDate getDate(int dateIndex) {
        String value = this.getString(dateIndex);
        if (NULL_DATE_VALUE.equals(value)) {
            return null;
        }
        return LocalDate.parse(value, DATE_PATTERN);
    }

    public LocalTime getTime(int timeIndex) {
        return LocalTime.parse(this.getString(timeIndex), TIME_PATTERN);
    }

    public LocalDateTime getDateAndTime(int dateIndex, int timeIndex) {
        return LocalDateTime.parse(this.getString(dateIndex) + this.getString(timeIndex), DATE_TIME_PATTERN);
    }

    public LocalDateTime getDateAndTimeSafe(int dateIndex, int timeIndex) {
        String date = this.getString(dateIndex);
        if (NULL_DATE_VALUE.equals(date)) {
            return null;
        }
        String time = StringUtils.trimToNull(this.getStringSafe(timeIndex));
        if (time == null) {
            return LocalDate.parse(date, DATE_PATTERN).atStartOfDay();
        }
        return LocalDateTime.parse(date + time, DATE_TIME_PATTERN);
    }

    public long getLong(int index) {
        return Long.parseLong(this.getString(index));
    }

    public Long getLongSafe(int index) {
        String stringSafe = this.getStringSafe(index);
        return stringSafe == null ? null : Long.valueOf(Long.parseLong(stringSafe));
    }

    public Integer getIntSafe(int index) {
        String stringSafe = this.getStringSafe(index);
        return stringSafe == null ? null : Integer.valueOf(Integer.parseInt(stringSafe));
    }

    public int getInt(int index) {
        return Integer.parseInt(this.getString(index));
    }

    public double getDouble(int index) {
        return Double.parseDouble(this.getString(index));
    }

    public boolean hasBit(int valueIndex, int bitIndex) {
        return (this.getLong(valueIndex) & 1L << bitIndex) > 0L;
    }

    public static LocalDate parseDateSafe(String value) {
        if (value == null || NULL_DATE_VALUE.equals(value)) {
            return null;
        }
        try {
            return LocalDate.parse(value, DATE_PATTERN);
        }
        catch (Exception e) {
            return null;
        }
    }
}

