/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.agent.agentDataTransfer.utils;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.comproxy.com.ByteArrayLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComProxyPacket {
    private static final Logger LOG = LoggerFactory.getLogger(ComProxyPacket.class);
    public static final byte STX = 2;
    private byte[] packetBody;
    private Integer packetId;
    private String packetCommand;
    private int recipientNumber = 1;

    public ComProxyPacket(byte[] packetBody, Integer packetId, String packetCommand) {
        this.packetBody = packetBody;
        this.packetId = packetId;
        this.packetCommand = packetCommand;
    }

    public static ComProxyPacket of(byte[] packetBody, Integer packetId, String packetCommand) {
        return new ComProxyPacket(packetBody, packetId, packetCommand);
    }

    public byte[] getPacketBody() {
        return this.packetBody;
    }

    public int getRecipientNumber() {
        return this.recipientNumber;
    }

    public void setRecipientNumber(int recipientNumber) {
        this.recipientNumber = recipientNumber;
    }

    public String getErrorCodeValue() {
        String result = "";
        int stxIndex = -1;
        for (int i = 0; i < this.packetBody.length; ++i) {
            byte b = this.packetBody[i];
            if (b != 2) continue;
            stxIndex = i;
        }
        int skipFirst = 3;
        if (stxIndex + skipFirst + 1 < this.packetBody.length) {
            byte[] value = new byte[2];
            System.arraycopy(this.packetBody, stxIndex + skipFirst + 1, value, 0, value.length);
            try {
                result = new String(value, "cp866");
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("", ex);
            }
        }
        return result;
    }

    public Integer getPacketId() {
        return this.packetId;
    }

    public String getPacketCommand() {
        return this.packetCommand;
    }

    public String toString() {
        int id = 0;
        if (this.packetId != null) {
            id = this.packetId & 0xFF;
        }
        return "#" + String.format("%02X", id) + " " + this.packetCommand + " " + new ByteArrayLog(this.packetBody);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComProxyPacket)) {
            return false;
        }
        ComProxyPacket packet = (ComProxyPacket)o;
        if (!Arrays.equals(this.packetBody, packet.packetBody)) {
            return false;
        }
        if (this.packetId != null ? !this.packetId.equals(packet.packetId) : packet.packetId != null) {
            return false;
        }
        return !(this.packetCommand != null ? !this.packetCommand.equals(packet.packetCommand) : packet.packetCommand != null);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.packetBody);
        result = 31 * result + (this.packetId != null ? this.packetId.hashCode() : 0);
        result = 31 * result + (this.packetCommand != null ? this.packetCommand.hashCode() : 0);
        return result;
    }
}

