/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.comproxy.utils.DeviceRegistryInfo;
import org.comproxy.utils.WinRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRegistryData {
    private static final Logger LOG = LoggerFactory.getLogger(WinRegistryData.class);
    private static final String registryKeyUsbList = "SYSTEM\\ControlSet001\\Enum\\USB\\VID_0483&PID_5740\\";
    private static final String driverKeyPath = "SYSTEM\\CurrentControlSet\\services\\usbser\\Enum";
    private static final String portNameField = "PortName";
    private static final String portNameRegistryPath = "HARDWARE\\DEVICEMAP\\SERIALCOMM\\";
    private static final String data = "\\Device\\USBSER0";
    private static final String deviceParametersField = "Device Parameters";
    private static final String registryDelimeter = "\\";
    static Map<String, String> cached = new HashMap<String, String>();

    public static synchronized String getWinRegistryFiscalPrinterNumber(String portName, Map<String, DeviceRegistryInfo> registryDevices) {
        try {
            String countStr;
            String usbIdValue;
            List<String> deviceIds;
            DeviceRegistryInfo lastDeviceIdNode = registryDevices.get(portName);
            if (lastDeviceIdNode != null) {
                if (WinRegistry.hasValue(lastDeviceIdNode.getPortNameNode(), portNameField, lastDeviceIdNode.getPortNameAsBytes()) && WinRegistry.hasValue(driverKeyPath, lastDeviceIdNode.getUsbId(), lastDeviceIdNode.getUsbIdNumberNodeValueAsBytes())) {
                    return lastDeviceIdNode.getUsbId();
                }
                registryDevices.remove(portName);
            }
            if ((deviceIds = WinRegistry.readStringSubKeys(registryKeyUsbList)).isEmpty()) {
                return null;
            }
            HashMap<String, String> deviceEnum = new HashMap<String, String>();
            for (int i = 0; i < 99 && (usbIdValue = WinRegistry.readString(driverKeyPath, countStr = String.valueOf(i))) != null; ++i) {
                deviceEnum.put(usbIdValue, countStr);
            }
            for (String deviceId : deviceIds) {
                String usbIdNumber;
                String registryPortName = WinRegistry.readString(registryKeyUsbList + deviceId + registryDelimeter + deviceParametersField, portNameField);
                if (!StringUtils.isNotBlank(registryPortName) || !StringUtils.isNotBlank(usbIdNumber = (String)deviceEnum.get("USB\\VID_0483&PID_5740\\" + deviceId))) continue;
                registryDevices.put(registryPortName, new DeviceRegistryInfo(registryPortName, deviceId, usbIdNumber));
            }
            DeviceRegistryInfo deviceRegistryInfo = registryDevices.get(portName);
            return deviceRegistryInfo == null ? null : deviceRegistryInfo.getUsbId();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static synchronized String getWinRegistryFiscalPrinterNumber(String portName) {
        String id = WinRegistryData.getIdForComPortName(portName);
        if (id != null) {
            return WinRegistryData.getRegistryNumberPrinterById(id);
        }
        return null;
    }

    private static String getIdForComPortName(String comPortName) {
        if (comPortName == null || comPortName.isEmpty()) {
            throw new IllegalArgumentException("'IdKey' null or empty");
        }
        try {
            List<String> idList = WinRegistryData.getListUsbPidVid(registryKeyUsbList);
            String portName = null;
            for (String id : idList) {
                portName = WinRegistryData.getPortNameForId(id);
                if (portName == null || !portName.equals(comPortName)) continue;
                return id;
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("", e);
            return null;
        }
    }

    private static String getPortNameForId(String IdKey) {
        if (IdKey == null || IdKey.isEmpty()) {
            throw new IllegalArgumentException("'IdKey' null or empty");
        }
        try {
            String devParamsPath = cached.computeIfAbsent(IdKey, s -> registryKeyUsbList + IdKey + registryDelimeter + deviceParametersField);
            return WinRegistry.readString(devParamsPath, portNameField);
        }
        catch (Exception e) {
            LOG.error("", e);
            return null;
        }
    }

    private static List<String> getListUsbPidVid(String registryKey) {
        if (registryKey == null || registryKey.isEmpty()) {
            throw new IllegalArgumentException("'registryKey' null or empty");
        }
        try {
            return WinRegistry.readStringSubKeys(registryKey);
        }
        catch (Exception e) {
            LOG.error("", e);
            return null;
        }
    }

    public static String cleanRegistry(String portName) {
        try {
            LOG.info("Clean Registry for {}", (Object)portName);
            HashMap<String, String> portRegistryMap = new HashMap<String, String>();
            for (int i = 0; i < 99; ++i) {
                String key = i < 10 ? "\\Device\\USBSER00" + i : data + i;
                String value = WinRegistry.readString(portNameRegistryPath, key);
                if (value == null) continue;
                portRegistryMap.put(key, value);
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : portRegistryMap.entrySet()) {
                if (!((String)entry.getValue()).equals(portName)) continue;
                sb.append((String)entry.getValue()).append(", ");
                WinRegistry.deleteValue(portNameRegistryPath, (String)entry.getKey());
            }
            return sb.toString();
        }
        catch (Exception ignore) {
            if (LOG.isDebugEnabled()) {
                LOG.error("cleanRegistry error: ", ignore);
            }
            return ignore.getMessage();
        }
    }

    private static String getRegistryNumberPrinterById(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("'registryKey' null or empty");
        }
        try {
            String tempId = null;
            int i = 0;
            while ((tempId = WinRegistry.readString(driverKeyPath, String.valueOf(i))) != null) {
                if ((tempId = tempId.substring(tempId.lastIndexOf(registryDelimeter) + 1)).equals(id)) {
                    return String.valueOf(i);
                }
                ++i;
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("", e);
            return null;
        }
    }
}

