/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class WinRegistry {
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int KEY_READ = 131097;
    private static final Preferences userRoot = Preferences.userRoot();
    private static final Preferences systemRoot = Preferences.systemRoot();
    private static final Class<? extends Preferences> userClass = userRoot.getClass();
    private static final Method regOpenKey;
    private static final Method regCloseKey;
    private static final Method regQueryValueEx;
    private static final Method regEnumValue;
    private static final Method regQueryInfoKey;
    private static final Method regEnumKeyEx;
    private static final Method regCreateKeyEx;
    private static final Method regDeleteValue;
    private static Map<String, Object[]> converted;
    private static Map<String, byte[]> cstrConverted;

    private WinRegistry() {
    }

    public static String readString(String key, String valueName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return WinRegistry.readString(systemRoot, key, valueName);
    }

    public static boolean hasValue(String key, String valueName, byte[] value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        byte[] bytes = WinRegistry.readStringAsBytes(systemRoot, key, valueName);
        return bytes != null && WinRegistry.isArrayEqualsCstr(bytes, value);
    }

    private static boolean isArrayEqualsCstr(byte[] cstr, byte[] expectedRegular) {
        int length = cstr.length - 1;
        if (expectedRegular.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (cstr[i] == expectedRegular[i]) continue;
            return false;
        }
        return true;
    }

    public static List<String> readStringSubKeys(String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return WinRegistry.readStringSubKeys(systemRoot, -2147483646, key);
    }

    public static void deleteValue(String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = WinRegistry.deleteValue(systemRoot, -2147483646, key, value);
        if (rc != 0) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key + "  value=" + value);
        }
    }

    private static int deleteValue(Preferences root, int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] handles = (int[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 983103);
        if (handles[1] != 0) {
            return handles[1];
        }
        int rc = (Integer)regDeleteValue.invoke((Object)root, handles[0], WinRegistry.toCstr(value));
        regCloseKey.invoke((Object)root, handles[0]);
        return rc;
    }

    private static String readString(Preferences root, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        byte[] valb = WinRegistry.readStringAsBytes(root, key, value);
        return valb != null ? new String(valb).trim() : null;
    }

    private static byte[] readStringAsBytes(Preferences root, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] params = converted.computeIfAbsent(key, s -> new Object[]{-2147483646, WinRegistry.toCstr(key), 131097});
        int[] handles = (int[])regOpenKey.invoke((Object)root, params);
        if (handles[1] != 0) {
            return null;
        }
        byte[] valb = (byte[])regQueryValueEx.invoke((Object)root, handles[0], cstrConverted.computeIfAbsent(value, s -> WinRegistry.toCstr(value)));
        regCloseKey.invoke((Object)root, handles[0]);
        return valb;
    }

    private static List<String> readStringSubKeys(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        int[] handles = (int[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
        if (handles[1] != 0) {
            return null;
        }
        int[] info = (int[])regQueryInfoKey.invoke((Object)root, handles[0]);
        int count = info[0];
        int maxlen = info[3];
        for (int index = 0; index < count; ++index) {
            byte[] name = (byte[])regEnumKeyEx.invoke((Object)root, handles[0], index, maxlen + 1);
            results.add(new String(name).trim());
        }
        regCloseKey.invoke((Object)root, handles[0]);
        return results;
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        System.arraycopy(str.getBytes(), 0, result, 0, str.length());
        result[str.length()] = 0;
        return result;
    }

    private static byte[] fromCstr(byte[] cstr) {
        return Arrays.copyOfRange(cstr, 0, cstr.length - 2);
    }

    static {
        converted = new HashMap<String, Object[]>();
        cstrConverted = new HashMap<String, byte[]>();
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
            regCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Integer.TYPE, byte[].class);
            regCreateKeyEx.setAccessible(true);
            regDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", Integer.TYPE, byte[].class);
            regDeleteValue.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

