/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.comproxy.utils.NameableThreadFactory;
import org.comproxy.utils.NamedTask;
import org.comproxy.utils.PriorityFutureTaskDecorator;

class PriorityScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    PriorityScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize, new NameableThreadFactory("#"));
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        if (runnable instanceof NamedTask) {
            return super.decorateTask(runnable, this.wrapTask((NamedTask)((Object)runnable), task));
        }
        return super.decorateTask(runnable, task);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        if (callable instanceof NamedTask) {
            return super.decorateTask(callable, this.wrapTask((NamedTask)((Object)callable), task));
        }
        return super.decorateTask(callable, task);
    }

    private <V> PriorityFutureTaskDecorator<V> wrapTask(NamedTask executable, RunnableScheduledFuture<V> task) {
        return new PriorityFutureTaskDecorator<V>(task, executable.getPriority(), executable.getName());
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        int priority = 5;
        String taskName = null;
        if (runnable instanceof PriorityFutureTaskDecorator) {
            PriorityFutureTaskDecorator taskDecorator = (PriorityFutureTaskDecorator)runnable;
            if (taskDecorator.getPriority() >= 1 && taskDecorator.getPriority() <= 10) {
                priority = taskDecorator.getPriority();
            }
            taskName = taskDecorator.getTaskName();
        }
        if (thread.getPriority() != priority) {
            thread.setPriority(priority);
            Thread.yield();
        }
        if (taskName != null) {
            this.setCustomThreadName(thread, taskName);
        }
        super.beforeExecute(thread, runnable);
    }

    private void setCustomThreadName(Thread thread, String taskName) {
        if (thread instanceof NameableThreadFactory.NameableThread) {
            ((NameableThreadFactory.NameableThread)thread).setNameForTask(taskName);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.resetCustomThreadName();
    }

    private void resetCustomThreadName() {
        Thread thread = Thread.currentThread();
        if (thread instanceof NameableThreadFactory.NameableThread) {
            ((NameableThreadFactory.NameableThread)thread).resetName();
        }
    }
}

