/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.utils;

import org.comproxy.utils.NamedTask;
import org.comproxy.utils.TaskParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class NamedRunnable
implements Runnable,
NamedTask {
    private static final Logger log = LoggerFactory.getLogger(NamedRunnable.class);
    private final Runnable original;
    private final String name;
    private final String logMark;
    private final int priority;

    public NamedRunnable(Runnable original, TaskParams taskParams) {
        this.original = original;
        this.name = taskParams.formatTaskName(original.hashCode());
        this.priority = taskParams.getPriority();
        this.logMark = taskParams.getLogMark();
    }

    @Override
    public void run() {
        if (this.logMark != null) {
            MDC.put("MARK", this.logMark);
        }
        try {
            this.original.run();
        }
        catch (Throwable e) {
            log.error("UncaughtException in thread {}", (Object)Thread.currentThread().getName(), (Object)e);
            throw e;
        }
        finally {
            if (this.logMark != null) {
                MDC.remove("MARK");
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

