/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.utils;

import java.util.concurrent.Callable;
import org.comproxy.utils.NamedTask;
import org.comproxy.utils.TaskParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class NamedCallable<V>
implements Callable<V>,
NamedTask {
    private static final Logger log = LoggerFactory.getLogger(NamedCallable.class);
    private final Callable<V> original;
    private final String name;
    private final int priority;
    private final String logMark;

    public NamedCallable(Callable<V> original, TaskParams taskParams) {
        this.original = original;
        this.name = taskParams.formatTaskName(original.hashCode());
        this.logMark = taskParams.getLogMark();
        this.priority = taskParams.getPriority();
    }

    @Override
    public V call() throws Exception {
        if (this.logMark != null) {
            MDC.put("MARK", this.logMark);
        }
        try {
            V v = this.original.call();
            return v;
        }
        catch (Throwable e) {
            log.error("UncaughtException in thread {}", (Object)Thread.currentThread().getName(), (Object)e);
            throw e;
        }
        finally {
            if (this.logMark != null) {
                MDC.remove("MARK");
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

