/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameableThreadFactory
implements ThreadFactory {
    private static final Logger logErrors = LoggerFactory.getLogger(NameableThreadFactory.class);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final CoreUncaughtExceptionHandler coreUncaughtExceptionHandler;

    NameableThreadFactory(String namePrefix) {
        this.namePrefix = namePrefix;
        this.coreUncaughtExceptionHandler = new CoreUncaughtExceptionHandler();
    }

    @Override
    public Thread newThread(Runnable r) {
        int threadNumber = this.threadNumber.getAndIncrement();
        NameableThread t = new NameableThread(r, this.namePrefix + (threadNumber >= 10 ? "" : "0") + threadNumber);
        Thread.setDefaultUncaughtExceptionHandler(this.coreUncaughtExceptionHandler);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    static class NameableThread
    extends Thread {
        private final Map<String, String> names = new HashMap<String, String>();
        private final String initialName;

        NameableThread(Runnable target, String initialName) {
            super(target, initialName + " (not used)");
            this.initialName = initialName;
        }

        void setNameForTask(String taskName) {
            if (taskName != null) {
                String cachedName = this.names.get(taskName);
                if (cachedName != null) {
                    this.setName(cachedName);
                } else {
                    this.setName(this.names.computeIfAbsent(taskName, s -> this.initialName + " " + s));
                }
            }
        }

        void resetName() {
            this.setName(this.initialName);
        }
    }

    public static class CoreUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (!(e instanceof ThreadDeath)) {
                logErrors.error("uncaughtException", e);
                e.printStackTrace();
            }
        }
    }
}

