/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.utils;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.comproxy.tcp.InternalExecutorApi;
import org.comproxy.utils.NamedCallable;
import org.comproxy.utils.NamedRunnable;
import org.comproxy.utils.PriorityScheduledThreadPoolExecutor;
import org.comproxy.utils.TaskParams;

public class InternalExecutor
implements InternalExecutorApi {
    private final PriorityScheduledThreadPoolExecutor pool;

    public InternalExecutor(int threadCount) {
        this.pool = new PriorityScheduledThreadPoolExecutor(threadCount);
    }

    @Override
    public ScheduledExecutorService getPool() {
        return this.pool;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long delay, TimeUnit unit, String description, String logMark) {
        TaskParams taskParams = TaskParams.normPriority(description + (logMark != null ? "-" + logMark : ""), true);
        taskParams.setLogMark(logMark);
        return this.pool.scheduleWithFixedDelay(new NamedRunnable(command, taskParams), 0L, delay, unit);
    }

    @Override
    public Future<?> submit(Runnable task, String description, String logMark, boolean singleInstance) {
        TaskParams taskParams = TaskParams.normPriority(description + (logMark != null ? "-" + logMark : ""), singleInstance);
        taskParams.setLogMark(logMark);
        return this.pool.submit(new NamedRunnable(task, taskParams));
    }

    @Override
    public <V> Future<V> submit(Callable<V> task, String description) {
        return this.pool.submit(new NamedCallable<V>(task, TaskParams.of(description)));
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.pool.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pool.awaitTermination(timeout, unit);
    }
}

