/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.utils;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jssc.SerialPortList;
import org.comproxy.CommonResources;
import org.comproxy.ProxyModel;
import org.comproxy.SystemInfo;
import org.comproxy.config.LinuxConnectorChecker;
import org.comproxy.config.ProxyConfig;
import org.comproxy.config.portFinder.PortFinderModel;
import org.comproxy.utils.DeviceRegistryInfo;
import org.comproxy.utils.WinRegistryData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HardwareChecker {
    private static final Logger LOG = LoggerFactory.getLogger(HardwareChecker.class);
    private static final int CHECK_CONNECTION_PAUSE = 1000;
    private static Map<String, DeviceRegistryInfo> registryDevices = new HashMap<String, DeviceRegistryInfo>();
    private final long lastAnswerTimeout = TimeUnit.SECONDS.toNanos(10L);
    private final long lastCommandTimeout = TimeUnit.SECONDS.toNanos(30L);
    private boolean portWasLost = false;
    private boolean usbConnection = true;
    private final SystemInfo info;
    private String portName;
    private String lastRegistryIndex;
    private ProxyConfig proxyConfig;
    private volatile boolean fiscalPrinterConnected = false;
    private volatile boolean needChangeMode = false;
    private String logMark = "";
    private boolean portLostLogMark = true;
    private volatile boolean started = false;
    private final ProxyModel model;

    public HardwareChecker(String portName, ProxyModel model) {
        this.portName = portName;
        this.model = model;
        this.logMark = model.getLogMark();
        this.info = new SystemInfo();
    }

    public boolean isFiscalPrinterConnected() {
        return !this.usbConnection || this.fiscalPrinterConnected;
    }

    public boolean isStarted() {
        return !this.usbConnection || this.started;
    }

    public boolean isNeedChangeMode() {
        return this.needChangeMode;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public void setUsbConnection(boolean usbConnection) {
        this.usbConnection = usbConnection;
    }

    private boolean doubleCheckConnection(String portName) {
        boolean printerExistInRegistry = false;
        printerExistInRegistry = this.info.isLinux() ? new File(portName).exists() : this.isStillExistInUSBRegistry(portName);
        if (printerExistInRegistry) {
            if (this.portWasLost) {
                if (this.model.getPrinterSerialNumber().equals("")) {
                    this.portWasLost = false;
                    this.portLostLogMark = true;
                    return true;
                }
                String tmpPortName = PortFinderModel.getInstance().checkPort(this.model.getPrinterSerialNumber(), this.proxyConfig, portName, this.logMark);
                if (tmpPortName != null) {
                    LOG.info("Port {} found without change name", (Object)this.portName);
                    this.portWasLost = false;
                    this.portLostLogMark = true;
                    return true;
                }
                tmpPortName = PortFinderModel.getInstance().findPort(this.model.getPrinterSerialNumber(), this.proxyConfig, this.logMark);
                if (tmpPortName != null && !tmpPortName.equals(portName)) {
                    this.portName = tmpPortName;
                    LOG.info("Port {} found for name {}", (Object)this.portName, (Object)this.model.getPrinterSerialNumber());
                    LOG.debug("needChangeMode = true");
                    this.needChangeMode = true;
                    this.portWasLost = false;
                    this.portLostLogMark = true;
                    return true;
                }
                if (this.portLostLogMark && !this.info.isLinux()) {
                    String s = WinRegistryData.cleanRegistry(portName);
                    LOG.error("Port {} not found by in registry 1: {}", (Object)this.portName, (Object)s);
                }
                this.portLostLogMark = false;
                this.portWasLost = true;
                return false;
            }
            this.portLostLogMark = true;
            return true;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException tmpPortName) {
            // empty catch block
        }
        if (!this.portWasLost && this.portLostLogMark) {
            if (!this.info.isLinux()) {
                String s = WinRegistryData.cleanRegistry(portName);
                LOG.error("Port {} not found in registry 2: {}", (Object)this.portName, (Object)s);
            }
            this.portLostLogMark = false;
        }
        this.portWasLost = true;
        if (this.model.getPrinterSerialNumber().equals("")) {
            this.portWasLost = false;
            return false;
        }
        String tmpPortName = PortFinderModel.getInstance().findPort(this.model.getPrinterSerialNumber(), this.proxyConfig, this.logMark);
        if (tmpPortName != null) {
            if (!tmpPortName.equals(this.portName)) {
                this.needChangeMode = true;
            }
            this.portName = tmpPortName;
            if (!this.proxyConfig.isFastStart()) {
                LOG.info("Port {} found for name {} with change id", (Object)this.portName, (Object)this.model.getPrinterSerialNumber());
            }
            this.portWasLost = false;
        }
        return false;
    }

    private synchronized String checkWinRegistryPrinterConnection(String portName) {
        String winRegistryFiscalPrinterNumber = WinRegistryData.getWinRegistryFiscalPrinterNumber(portName, registryDevices);
        if (winRegistryFiscalPrinterNumber != null && !winRegistryFiscalPrinterNumber.equals(this.lastRegistryIndex)) {
            this.lastRegistryIndex = winRegistryFiscalPrinterNumber;
            LOG.debug("lastRegistryIndex = {}", (Object)this.lastRegistryIndex);
        }
        return winRegistryFiscalPrinterNumber;
    }

    private boolean checkConnection() {
        boolean connected;
        String tmpPortName;
        if (!this.usbConnection) {
            return true;
        }
        if (this.info.isLinux() && this.proxyConfig.getFindPidVid() && !(tmpPortName = LinuxConnectorChecker.chekPiritLinuxConnection()).isEmpty() && !tmpPortName.equals(this.proxyConfig.getVirtualPortPrinter1())) {
            this.proxyConfig.getPhysicalPortPrinter1(tmpPortName);
            this.portName = tmpPortName;
            LOG.error("Set PhysicalPort - {} in ComProxy.ini ", (Object)tmpPortName);
        }
        if ((connected = this.doubleCheckConnection(this.portName)) && !this.info.isLinux() && this.model.isKktAnswerExpired(this.lastAnswerTimeout, this.lastCommandTimeout)) {
            this.model.resetKktAnswerTimeout();
            LOG.warn("Physical port answer timeout expired. Will try to reconnect");
            return false;
        }
        return connected;
    }

    public void start() {
        if (!this.usbConnection) {
            return;
        }
        if (this.isWindowsUSBPort(this.portName)) {
            LOG.debug("It seems {} is not virtual port (USB check connection will be disabled)", (Object)this.portName);
            this.usbConnection = false;
            return;
        }
        CommonResources.getInstance().getPool().scheduleWithFixedDelay(this::checkConnectionTask, 1000L, TimeUnit.MILLISECONDS, "HardwareChecker", this.model.getLogMark());
    }

    private boolean isWindowsUSBPort(String portName) {
        if (this.info.isLinux()) {
            return false;
        }
        if (this.isExistInUSBRegistry(portName)) {
            return false;
        }
        HashSet<String> portNames = new HashSet<String>(Arrays.asList(SerialPortList.getPortNames()));
        if (!portNames.contains(this.portName)) {
            return false;
        }
        return !this.isExistInUSBRegistry(portName);
    }

    private boolean isExistInUSBRegistry(String portName) {
        return this.checkWinRegistryPrinterConnection(portName) != null;
    }

    private boolean isStillExistInUSBRegistry(String portName) {
        String lastIndex = this.lastRegistryIndex;
        String registryIndex = this.checkWinRegistryPrinterConnection(portName);
        return registryIndex != null && registryIndex.equals(lastIndex);
    }

    private void checkConnectionTask() {
        try {
            boolean newStatus = this.checkConnection();
            this.started = true;
            if (newStatus != this.fiscalPrinterConnected) {
                this.fiscalPrinterConnected = newStatus;
                LOG.debug("Connection {}: {}", (Object)this.portName, (Object)(newStatus ? "connected" : "disconnected"));
                this.model.signalPhysical();
            }
        }
        catch (Exception e) {
            LOG.error("CheckConnectionThread error", e);
        }
    }
}

