/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.utils;

public class DeviceRegistryInfo {
    private static final String USB_VID_0483_PID_5740 = "USB\\VID_0483&PID_5740\\";
    private static final String registryKeyUsbList = "SYSTEM\\ControlSet001\\Enum\\USB\\VID_0483&PID_5740\\";
    private static final String driverKeyPath = "SYSTEM\\CurrentControlSet\\services\\usbser\\Enum";
    public static final String portNameField = "PortName";
    private static final String portNameRegistryPath = "HARDWARE\\DEVICEMAP\\SERIALCOMM\\";
    private static final String data = "\\Device\\USBSER0";
    private static final String deviceParametersField = "Device Parameters";
    private final String portName;
    private final String usbId;
    private final String portNameNode;
    private final byte[] portNameBytes;
    private final byte[] usbIdNumberNodeValueAsBytes;

    public DeviceRegistryInfo(String portName, String deviceId, String usbId) {
        this.portName = portName;
        this.portNameBytes = portName.getBytes();
        this.usbId = usbId;
        this.portNameNode = registryKeyUsbList + deviceId + "\\" + deviceParametersField;
        this.usbIdNumberNodeValueAsBytes = (USB_VID_0483_PID_5740 + deviceId).getBytes();
    }

    public String getPortName() {
        return this.portName;
    }

    public byte[] getPortNameAsBytes() {
        return this.portNameBytes;
    }

    public String getUsbId() {
        return this.usbId;
    }

    public String getPortNameNode() {
        return this.portNameNode;
    }

    public byte[] getUsbIdNumberNodeValueAsBytes() {
        return this.usbIdNumberNodeValueAsBytes;
    }
}

