/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.tcp.posIpTransport;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.comproxy.ProxyModel;
import org.comproxy.tcp.posIpTransport.PosIpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosIpTrafficServer
extends Thread {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    private int serverPort = 50001;
    private final String address = "127.0.0.1";
    protected ProxyModel model;
    private Thread socketReader;
    private Socket socket = null;
    private ServerSocket cashTrafficServer = null;
    private PosIpTransport posIpTransport = null;

    private PosIpTransport getIpTransport(Socket socket, ProxyModel model) throws IOException {
        return new PosIpTransport(socket, model);
    }

    public PosIpTrafficServer(ProxyModel model) {
        this.model = model;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        if (this.socketReader != null) {
            this.socketReader.interrupt();
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.LOG.error("Error close socket", e);
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    this.LOG.error("Error close socket finally", e);
                }
            }
        }
        if (this.cashTrafficServer != null) {
            try {
                this.cashTrafficServer.close();
            }
            catch (IOException e) {
                this.LOG.error("Error close serverSocket", e);
            }
            finally {
                try {
                    this.cashTrafficServer.close();
                }
                catch (IOException e) {
                    this.LOG.error("Error close serverSocket finally", e);
                }
            }
        }
    }

    @Override
    public void run() {
        this.model.setLogMarkMdc();
        try {
            while (!Thread.interrupted()) {
                this.model.waitForFRConnected();
                this.cashTrafficServer = new ServerSocket(this.serverPort);
                this.LOG.debug("Wait IP Client connection to 127.0.0.1:" + this.serverPort);
                this.socket = this.cashTrafficServer.accept();
                this.LOG.debug("IP Client connected");
                if (this.socketReader == null) {
                    this.posIpTransport = this.getIpTransport(this.socket, this.model);
                    this.socketReader = new Thread(this.posIpTransport);
                    this.socketReader.start();
                }
                while (this.posIpTransport != null && this.posIpTransport.isActive()) {
                    Thread.sleep(50L);
                }
                this.socketReader.interrupt();
                this.socket.close();
                this.cashTrafficServer.close();
                this.socketReader = null;
                Thread.sleep(50L);
                this.LOG.debug("Client disconnected");
            }
        }
        catch (IOException e) {
            this.LOG.error("Error start server {} {} {}", "127.0.0.1", this.serverPort, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

