/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.tcp.agentIpTransport;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import org.comproxy.CommonResources;
import org.comproxy.com.ByteArrayLog;
import org.comproxy.reader.ComPacket;
import org.comproxy.reader.PackageReader;
import org.comproxy.reader.PackageReaderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentIpTrafficReader
extends Thread
implements PackageReaderListener {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    private Socket socket;
    private DataInputStream bis;
    protected PackageReader packageReader;
    private volatile boolean active = true;
    private byte[] data = new byte[4096];
    private int byteCount = 0;

    public AgentIpTrafficReader(Socket s) throws IOException {
        this.socket = s;
        this.bis = new DataInputStream(s.getInputStream());
        this.active = true;
        this.packageReader = new PackageReader(true, this);
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                this.readData(this.bis);
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.LOG.error("Error", e);
        }
        finally {
            try {
                this.closeStream();
                this.socket.close();
            }
            catch (Exception e) {
                this.LOG.error("Error", e);
            }
        }
    }

    private void readData(DataInputStream in) throws Exception {
        try {
            long readStartTime = System.currentTimeMillis();
            boolean endTimeOut = false;
            while (!endTimeOut) {
                this.byteCount = in.read(this.data);
                if (this.byteCount > 0) {
                    byte[] methodBuffer = new byte[this.byteCount];
                    System.arraycopy(this.data, 0, methodBuffer, 0, this.byteCount);
                    this.LOG.debug("read --> {}", (Object)new ByteArrayLog(methodBuffer));
                    this.packageReader.write(methodBuffer, this.byteCount);
                    continue;
                }
                if (this.byteCount == 0) {
                    if (System.currentTimeMillis() < readStartTime + 1000L) continue;
                    endTimeOut = true;
                    continue;
                }
                if (this.byteCount >= 0) continue;
                throw new IOException("Socket close");
            }
        }
        catch (IOException eio) {
            this.LOG.error("Error", eio);
            Thread.currentThread().interrupt();
            this.closeStream();
            this.active = false;
        }
    }

    @Override
    public void command(ComPacket result) {
        this.LOG.debug("command --> {}", (Object)result);
        if (CommonResources.getInstance().getComProxyApi().send(result)) {
            this.LOG.debug("sent to physical --> {}", (Object)result);
        }
        this.LOG.debug("not sent to physical --> {}", (Object)result);
    }

    public boolean isActive() {
        return this.active;
    }

    private void closeStream() {
        if (this.bis != null) {
            try {
                this.bis.close();
                this.bis = null;
            }
            catch (IOException e) {
                this.LOG.error("Error input stream error", e);
            }
        }
    }
}

