/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.tcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.comproxy.ProxyModel;
import org.comproxy.SettingsManager;
import org.comproxy.com.ByteArrayLog;
import org.comproxy.reader.ComPacket;
import org.comproxy.reader.TcpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPThread
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TCPThread.class);
    private static final int HEADER_SIZE = 30;
    private final SettingsManager settings;
    private ByteArrayOutputStream tcpBodyOut = new ByteArrayOutputStream();
    private TcpHeader tcpHeader = null;
    private ProxyModel model;
    private final int readTimeout = (int)TimeUnit.SECONDS.toMillis(20L);
    private final int connectTimeout = (int)TimeUnit.SECONDS.toMillis(10L);

    public TCPThread(ProxyModel model) {
        this.model = model;
        this.settings = model.getSettings();
    }

    public void setTcpHeader(TcpHeader tcpHeader) {
        this.tcpHeader = tcpHeader;
    }

    @Override
    public void run() {
        this.model.setLogMarkMdc();
        LOG.debug("TCP thread started");
        while (!Thread.interrupted()) {
            try {
                ComPacket packet = this.model.getPacketToTcp();
                if (packet == null) continue;
                this.exchange(packet);
            }
            catch (InterruptedException ie) {
                break;
            }
            catch (Exception ex) {
                try {
                    Thread.sleep(1000L);
                    LOG.error("", ex);
                }
                catch (InterruptedException ex1) {
                    break;
                }
            }
        }
        LOG.debug("TCP finished");
    }

    private void exchange(ComPacket packet) {
        TcpHeader header = packet.getTcpHeader();
        if (header.getSeqNo() == 1L) {
            this.tcpBodyOut.reset();
            this.tcpHeader = header;
        }
        this.tcpBodyOut.write(packet.getPacketBody(), 40, packet.getPacketBody().length - 40);
        if (header.getSeqNo() == header.getArcNo()) {
            this.sendPacket();
        } else if (header.getSeqNo() > header.getArcNo()) {
            LOG.debug("try write seq = {} of arc = {}", (Object)header.getSeqNo(), (Object)header.getArcNo());
        }
    }

    private void closeSocket(Socket requestSocket) {
        try {
            requestSocket.close();
        }
        catch (IOException ex) {
            LOG.warn("Error on close socket: {}", (Object)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacket() {
        Socket requestSocket;
        block13: {
            int port;
            String host;
            block14: {
                this.model.setAutoAnswerMode(false);
                requestSocket = null;
                host = this.tcpHeader.getDstIp();
                port = this.tcpHeader.getDstPort();
                this.model.tcpSendInProcess(true);
                if (this.tcpHeader.getDstIp().equals("0.0.0.0")) {
                    this.model.sendFailTcpCommandToPhysic();
                    if (this.model.isTcpReadMode()) {
                        this.settings.refresh(this.settings.getOfdIP());
                        this.settings.refresh(this.settings.getOismIP());
                    }
                    break block13;
                }
                requestSocket = new Socket();
                requestSocket.setSoTimeout(this.readTimeout);
                InetSocketAddress socketAddress = new InetSocketAddress(host, port);
                requestSocket.connect(socketAddress, this.connectTimeout);
                if (this.model.isTcpReadMode()) break block14;
                LOG.debug("Sending will not be performed (tcp mode disabled)");
                this.model.tcpSendInProcess(false);
                if (requestSocket != null) {
                    this.closeSocket(requestSocket);
                }
                return;
            }
            try {
                this.send(requestSocket.getOutputStream());
                this.read(requestSocket.getInputStream());
                this.model.getModeManager().getCoolDownMode(host, port).disable();
            }
            catch (Exception ex) {
                try {
                    LOG.error("Unable to connect to {}:{} ({})", host, port, ex.getMessage());
                    if (this.model.isTcpReadMode()) {
                        this.model.sendFirstStopTcp("Unable to connect");
                    }
                    this.model.getModeManager().getCoolDownMode(host, port).tryToEnable();
                    if (this.model.isTcpReadMode()) {
                        this.settings.refreshIfExpired(this.settings.getOfdIP());
                        this.settings.refreshIfExpired(this.settings.getOismIP());
                    }
                    this.model.tcpSendInProcess(false);
                    if (requestSocket != null) {
                        this.closeSocket(requestSocket);
                    }
                }
                catch (Throwable throwable) {
                    this.model.tcpSendInProcess(false);
                    if (requestSocket != null) {
                        this.closeSocket(requestSocket);
                    }
                    throw throwable;
                }
            }
        }
        this.model.tcpSendInProcess(false);
        if (requestSocket != null) {
            this.closeSocket(requestSocket);
        }
    }

    private void send(OutputStream out) throws IOException {
        if (!this.model.isTcpReadMode()) {
            LOG.debug("Sending will not be performed (tcp mode disabled)");
            return;
        }
        byte[] bytes = this.tcpBodyOut.toByteArray();
        LOG.debug("Sending data ({}): {}", (Object)bytes.length, (Object)ByteArrayLog.onlyHex(bytes));
        out.write(bytes);
        out.flush();
    }

    protected void read(InputStream in) throws IOException {
        if (!this.model.isTcpReadMode()) {
            LOG.debug("Reading will not be performed (tcp mode disabled)");
            return;
        }
        byte[] head = this.readSocketStream(in, 30, "head");
        int messageLength = TCPThread.getPacketLength(head);
        LOG.debug("Read header (message length {}): {}", (Object)messageLength, (Object)ByteArrayLog.onlyHex(head));
        byte[] data = this.readSocketStream(in, messageLength, "body");
        LOG.debug("Read data ({}): {}", (Object)data.length, (Object)ByteArrayLog.onlyHex(data));
        ByteArrayOutputStream fullOut = new ByteArrayOutputStream(head.length + data.length);
        fullOut.write(head);
        fullOut.write(data);
        if (!this.model.isTcpReadMode()) {
            LOG.debug("Answer will be discarded (tcp mode disabled)");
            return;
        }
        this.model.responseTCP(this.getResponseTcpCommand(fullOut));
    }

    private ComPacket getResponseTcpCommand(ByteArrayOutputStream response) throws IOException {
        ComPacket headerPacket = ProxyModel.makeCommand(132, 118, ComPacket.STATUS.TCP, "" + response.size());
        ComPacket bodyPacket = this.getResponse(response);
        headerPacket.setBodyPacket(bodyPacket);
        return headerPacket;
    }

    private ComPacket getResponse(ByteArrayOutputStream response) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TcpHeader responseTcpHeader = new TcpHeader(this.tcpHeader.asResponse(response.size() + 40));
        baos.write(responseTcpHeader.getBody());
        baos.write(response.toByteArray());
        return new ComPacket(baos.toByteArray(), ComPacket.STATUS.TCP, null, null, responseTcpHeader);
    }

    private byte[] readSocketStream(InputStream is, int partSize, String description) throws IOException {
        byte[] head = new byte[partSize];
        int allCount = 0;
        long timeOutStart = System.currentTimeMillis();
        while (is.available() >= 0) {
            int read = is.read(head, allCount, partSize - allCount);
            allCount += read;
            if (read == -1) {
                throw new IOException("read TCP " + description + " fail");
            }
            if (read == 0) {
                if (timeOutStart + (long)this.readTimeout > System.currentTimeMillis()) {
                    throw new IOException("Timeout get answer " + description + " from Server");
                }
            } else {
                timeOutStart = System.currentTimeMillis();
            }
            if (allCount < partSize) continue;
        }
        if (allCount == partSize) {
            return head;
        }
        throw new IOException("Can't get answer " + description + " from Server, get " + allCount + " bytes");
    }

    private static int getPacketLength(byte[] buffer) {
        return buffer[24] & 0xFF | (buffer[25] & 0xFF) << 8;
    }
}

