/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.tcp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.comproxy.config.ProxyConfig;
import org.comproxy.tcp.HostResolutionResult;
import org.comproxy.tcp.InternalExecutorApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundHostResolver
implements Callable<String> {
    private static final Logger log = LoggerFactory.getLogger(BackgroundHostResolver.class);
    private static final String LOCALHOST = "127.0.0.1";
    private final Map<String, HostResolutionResult> resolvedHost = Collections.synchronizedMap(new HashMap());
    private final Map<String, Long> toResolve = Collections.synchronizedMap(new HashMap());
    private final ReentrantLock submissionLock = new ReentrantLock();
    private final AtomicReference<Future<String>> resolvingFuture = new AtomicReference();
    private final InternalExecutorApi executor;
    private final ProxyConfig proxyConfig;

    public BackgroundHostResolver(InternalExecutorApi executor, ProxyConfig proxyConfig) {
        this.executor = executor;
        this.proxyConfig = proxyConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() {
        HashSet<String> hostsToResolve;
        this.submissionLock.lock();
        try {
            hostsToResolve = new HashSet<String>(this.toResolve.keySet());
            this.toResolve.clear();
        }
        finally {
            this.submissionLock.unlock();
        }
        for (String hostToResolve : hostsToResolve) {
            String resolved = this.resolveHost(hostToResolve);
            if (this.isValidResolved(resolved)) {
                this.saveResult(hostToResolve, resolved, TimeUnit.SECONDS.toMillis(this.proxyConfig.getDnsResultLifetime()));
                continue;
            }
            this.saveResult(hostToResolve, null, TimeUnit.SECONDS.toMillis(this.proxyConfig.getDnsInvalidResultLifetime()));
        }
        this.submissionLock.lock();
        try {
            if (!this.toResolve.isEmpty()) {
                log.debug("Rescheduling resolving");
                this.resolvingFuture.set(this.executor.submit(this, "BackgroundHostResolver"));
            }
        }
        finally {
            this.submissionLock.unlock();
        }
        return null;
    }

    private boolean isValidResolved(String rawResolved) {
        String resolved = StringUtils.trimToNull(rawResolved);
        return resolved != null && !resolved.equals(LOCALHOST);
    }

    private void saveResult(String hostToResolve, String resolved, long millis) {
        this.resolvedHost.put(hostToResolve, new HostResolutionResult(resolved, System.currentTimeMillis() + millis));
    }

    private String resolveHost(String host) {
        try {
            log.trace("Starting resolving host {}...", (Object)host);
            String result = InetAddress.getByName(host).getHostAddress();
            log.trace("Host {} resolved to IP {}", (Object)host, (Object)result);
            return result;
        }
        catch (UnknownHostException e) {
            log.debug("Unknown host {}", (Object)host);
        }
        catch (Exception e) {
            log.debug("Unknown host {}: {}", (Object)host, (Object)e.getMessage());
        }
        return null;
    }

    public String resolve(String host) {
        if (!this.proxyConfig.useDnsResolving()) {
            return null;
        }
        HostResolutionResult resolved = this.resolvedHost.get(host);
        if (resolved == null) {
            log.trace("No result yet for host {}. To submit to resolve", (Object)host);
            return this.submitToResolve(host);
        }
        if (this.isExpired(resolved)) {
            log.trace("Expired result for host {}. To submit to resolve", (Object)host);
            return this.submitToResolve(host, resolved);
        }
        String result = resolved.getIp();
        log.trace("Cached resolved result {} for host {}", (Object)result, (Object)host);
        return result;
    }

    private String getResolved(String host) {
        HostResolutionResult resolved = this.resolvedHost.get(host);
        if (resolved != null && !this.isExpired(resolved)) {
            return resolved.getIp();
        }
        return null;
    }

    private String submitToResolve(String host) {
        this.submissionLock.lock();
        try {
            this.toResolve.put(host, System.currentTimeMillis());
        }
        finally {
            this.submissionLock.unlock();
        }
        Future<String> existFuture = this.resolvingFuture.get();
        if (existFuture != null && !existFuture.isDone()) {
            log.trace("Already submitted");
            return null;
        }
        Future<String> result = this.executor.submit(this, "BackgroundHostResolver");
        this.resolvingFuture.set(result);
        try {
            result.get(this.proxyConfig.getDnsResolvingTimeout(), TimeUnit.SECONDS);
            String resolved = this.getResolved(host);
            if (resolved != null) {
                log.trace("Resolved result {} for host {}", (Object)resolved, (Object)host);
            }
            return resolved;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (TimeoutException e) {
            log.trace("Host resolving not finished in {} seconds", (Object)this.proxyConfig.getDnsResolvingTimeout());
            return null;
        }
    }

    private String submitToResolve(String host, HostResolutionResult expiredResult) {
        String actualHost = this.submitToResolve(host);
        if (actualHost != null) {
            return actualHost;
        }
        return expiredResult.getIp();
    }

    private boolean isExpired(HostResolutionResult resolved) {
        return System.currentTimeMillis() > resolved.getResolvedTime();
    }
}

