/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.reader;

import java.io.ByteArrayOutputStream;
import org.comproxy.com.ByteArrayLog;
import org.comproxy.reader.ComPacket;
import org.comproxy.reader.PackageReaderListener;
import org.comproxy.reader.TcpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageReader {
    private static final Logger LOG = LoggerFactory.getLogger(PackageReader.class);
    public static final byte STX = 2;
    public static final byte ETX = 3;
    public static final byte ACK = 6;
    public static final byte NAK = 21;
    public static final byte CANCEL_DC3 = 19;
    public static final byte FS = 28;
    public static final byte EOT = 4;
    public static final byte ENQ = 5;
    public static final byte TCP = 69;
    private PackageReaderListener listener;
    private ComPacket.STATUS status = ComPacket.STATUS.ERROR;
    private Byte crc;
    private Integer packetId;
    private String packetCommand = "";
    private boolean isEtx = false;
    private byte[] tcpHeaderSource = new byte[40];
    private int tcpHeaderIndex;
    private TcpHeader tcpHeader;
    private ByteArrayOutputStream body = new ByteArrayOutputStream();
    private long lastPacketTime = 0L;
    private int tcpLen;
    private boolean virtual;
    private String prefix;

    public PackageReader(boolean virtual, PackageReaderListener listener) {
        this.virtual = virtual;
        this.listener = listener;
    }

    public ComPacket write(byte[] stream, int length) {
        if (System.currentTimeMillis() - this.lastPacketTime > 30000L) {
            this.status = ComPacket.STATUS.ERROR;
            if (this.body.size() > 0) {
                LOG.info("Timeout reset stack of readed data, stack was not empty: {}", (Object)ByteArrayLog.onlyHex(this.body.toByteArray()));
                this.body.reset();
            }
        }
        this.lastPacketTime = System.currentTimeMillis();
        for (int i = 0; i < length; ++i) {
            byte b = stream[i];
            this.body.write(b);
            if (this.status == ComPacket.STATUS.ERROR || this.status == ComPacket.STATUS.END || this.status == ComPacket.STATUS.ENDTCP) {
                this.tcpHeader = null;
                if (b == 2) {
                    this.tcpHeaderIndex = 0;
                    this.isEtx = false;
                    this.status = ComPacket.STATUS.PACKET;
                    continue;
                }
                if (b == 5 || b == 6) {
                    this.status = ComPacket.STATUS.END;
                    this.pushPacket();
                    continue;
                }
                if (this.likeTcpPacket(stream, b, i, length)) {
                    this.status = ComPacket.STATUS.TCP;
                    this.tcpHeaderIndex = 0;
                    this.tcpHeaderSource[this.tcpHeaderIndex] = b;
                    continue;
                }
                this.status = ComPacket.STATUS.ERROR;
                this.pushPacket();
                continue;
            }
            if (this.status == ComPacket.STATUS.PACKET) {
                this.parsePacket(b);
                continue;
            }
            if (this.status != ComPacket.STATUS.TCP) continue;
            this.parseTCP(b);
        }
        return new ComPacket(this.body.toByteArray(), this.status, this.packetId, this.packetCommand, this.tcpHeader);
    }

    private boolean likeTcpPacket(byte[] stream, byte b, int i, int length) {
        return b == 69 && (length == 1 || length >= i + 2 && stream[i + 1] == 0);
    }

    private void pushPacket() {
        LOG.debug("pushPacket {} {}", (Object)this.packetId, (Object)this.packetCommand);
        if (this.listener != null) {
            try {
                LOG.debug("listener {} {}", (Object)this.listener.getClass());
                this.listener.command(new ComPacket(this.body.toByteArray(), this.status, this.packetId, this.packetCommand, this.tcpHeader));
            }
            catch (Throwable e) {
                LOG.error("", e);
            }
        }
        this.packetId = null;
        this.packetCommand = "";
        this.prefix = "";
        this.body.reset();
    }

    private void parsePacket(byte b) {
        if (b == 3) {
            this.isEtx = true;
            this.crc = null;
        } else if (this.isEtx) {
            if (this.crc == null) {
                this.crc = b;
            } else {
                this.status = ComPacket.STATUS.END;
                this.pushPacket();
            }
        } else if (this.virtual && this.prefix == null) {
            this.prefix = "" + (char)b;
        } else if (this.virtual && this.prefix.length() < 4) {
            this.prefix = this.prefix + "" + (char)b;
        } else if (this.packetId == null) {
            this.packetId = b & 0xFF;
        } else if (this.packetCommand == null || this.packetCommand.isEmpty()) {
            this.packetCommand = "" + (char)b;
        } else if (this.packetCommand.length() == 1) {
            this.packetCommand = this.packetCommand + "" + (char)b;
        }
    }

    private void parseTCP(byte b) {
        ++this.tcpHeaderIndex;
        if (this.tcpHeaderIndex < this.tcpHeaderSource.length) {
            this.tcpHeaderSource[this.tcpHeaderIndex] = b;
            if (this.tcpHeaderIndex == this.tcpHeaderSource.length - 1) {
                this.tcpHeader = new TcpHeader(this.tcpHeaderSource);
                this.tcpLen = this.tcpHeader.getLen();
            }
        } else if (this.tcpHeaderIndex >= this.tcpLen - 1) {
            this.status = ComPacket.STATUS.ENDTCP;
            this.pushPacket();
        }
    }
}

