/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.reader;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.comproxy.com.ByteArrayLog;
import org.comproxy.reader.TcpHeader;
import org.comproxy.utils.ComUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComPacket {
    public static final ComPacket ACK_PACKET = new ComPacket(new byte[]{6});
    public static final ComPacket NAK_PACKET = new ComPacket(new byte[]{21});
    public static final ComPacket DC3_PACKET = new ComPacket(new byte[]{19});
    public static final Charset CP_866 = Charset.forName("cp866");
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    private ComPacket bodyPacket;
    private byte[] packetBody;
    private STATUS status;
    private Integer packetId;
    private String packetCommand;
    private TcpHeader tcpHeader;
    private int recipientNumber = 1;

    public ComPacket(byte[] packetBody) {
        this(packetBody, STATUS.END, null, null);
    }

    public ComPacket(byte[] packetBody, STATUS status, Integer packetId, String packetCommand) {
        this(packetBody, status, packetId, packetCommand, null);
    }

    public ComPacket(byte[] packetBody, STATUS status, Integer packetId, String packetCommand, TcpHeader tcpHeader) {
        this.packetBody = packetBody;
        this.status = status;
        this.packetId = packetId;
        this.packetCommand = packetCommand;
        this.tcpHeader = tcpHeader;
    }

    public TcpHeader getTcpHeader() {
        return this.tcpHeader;
    }

    public boolean testCommand(byte shortCommand) {
        return this.packetBody.length == 1 && this.packetBody[0] == shortCommand;
    }

    public void setPacketBody(byte[] packetBody) {
        this.packetBody = packetBody;
    }

    public byte[] getPacketBody() {
        return this.packetBody;
    }

    public int getRecipientNumber() {
        return this.recipientNumber;
    }

    public void setRecipientNumber(int recipientNumber) {
        this.recipientNumber = recipientNumber;
    }

    public String getPacketValueOnly() {
        return new String(this.packetBody, 2, this.packetBody.length - 3 - 2, CP_866);
    }

    public String getPacketValue() {
        int skipFirst;
        String result = "";
        int stxIndex = -1;
        int etxIndex = -1;
        for (int i = 0; i < this.packetBody.length; ++i) {
            byte b = this.packetBody[i];
            if (b == 2) {
                stxIndex = i;
                continue;
            }
            if (b != 3 && b != 28) continue;
            etxIndex = i;
            break;
        }
        if (etxIndex - (skipFirst = 5) > stxIndex && stxIndex >= 0) {
            byte[] value = new byte[etxIndex - stxIndex - skipFirst - 1];
            System.arraycopy(this.packetBody, stxIndex + skipFirst + 1, value, 0, value.length);
            result = new String(value, CP_866);
        }
        return result;
    }

    public String getErrorCodeValue() {
        int skipFirst;
        String result = "";
        int stxIndex = -1;
        int etxIndex = -1;
        for (int i = 0; i < this.packetBody.length; ++i) {
            byte b = this.packetBody[i];
            if (b == 2) {
                stxIndex = i;
                continue;
            }
            if (b != 3 && b != 28) continue;
            etxIndex = i;
            break;
        }
        if (etxIndex - (skipFirst = 3) > stxIndex && stxIndex >= 0) {
            byte[] value = new byte[2];
            System.arraycopy(this.packetBody, stxIndex + skipFirst + 1, value, 0, value.length);
            result = new String(value, CP_866);
        }
        return result;
    }

    public boolean isSuccessResponse() {
        return "00".equals(this.getErrorCodeValue());
    }

    public String getSerialNumberValue() {
        byte b;
        int i;
        String result = "";
        int stxIndex = -1;
        int etxIndex = -1;
        int startFsIndex = -1;
        int endFsIndex = -1;
        for (i = 0; i < this.packetBody.length; ++i) {
            b = this.packetBody[i];
            if (b == 2) {
                stxIndex = i;
                continue;
            }
            if (b != 28) continue;
            startFsIndex = i;
            break;
        }
        for (i = startFsIndex + 1; i > etxIndex; ++i) {
            b = this.packetBody[i];
            if (b != 28) continue;
            endFsIndex = i;
            break;
        }
        int skipFirst = 5;
        byte[] value = new byte[endFsIndex - startFsIndex];
        System.arraycopy(this.packetBody, startFsIndex, value, 0, value.length);
        result = new String(value, CP_866);
        return result;
    }

    public String getPacketValueByIndex(int number) {
        byte b;
        int i;
        if (number == 0) {
            return this.getPacketValue();
        }
        String result = "";
        int stxIndex = -1;
        int etxIndex = -1;
        int fsIndexPrevios = 0;
        int fsIndexNext = 6;
        int indexNumber = 0;
        for (i = 0; i < this.packetBody.length; ++i) {
            b = this.packetBody[i];
            if (b == 2) {
                stxIndex = i;
                continue;
            }
            if (b != 3) continue;
            etxIndex = i;
            break;
        }
        for (i = stxIndex; i < etxIndex; ++i) {
            b = this.packetBody[i];
            if (b == 28) {
                fsIndexPrevios = fsIndexNext;
                fsIndexNext = i;
                ++indexNumber;
            }
            if (indexNumber - 1 == number) {
                byte[] value = new byte[fsIndexNext - fsIndexPrevios - 1];
                System.arraycopy(this.packetBody, stxIndex + fsIndexPrevios + 1, value, 0, value.length);
                try {
                    result = new String(value, "cp866");
                }
                catch (UnsupportedEncodingException e) {
                    this.LOG.error("Error get value {} from packet: {}", number, this, e);
                }
                continue;
            }
            if (b != 3) continue;
            etxIndex = i;
            break;
        }
        return result;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public Integer getPacketId() {
        return this.packetId;
    }

    public String getPacketCommand() {
        return this.packetCommand;
    }

    public boolean checkTcpCrc() {
        boolean result = true;
        if (this.packetBody != null && this.packetBody.length > 11) {
            byte expectedCrc = this.packetBody[10];
            this.packetBody[11] = 0;
            this.packetBody[10] = 0;
            byte actualCrc = ComUtils.byteCrc(this.packetBody);
            result = expectedCrc == actualCrc;
        }
        return result;
    }

    public void setBodyPacket(ComPacket bodyPacket) {
        this.bodyPacket = bodyPacket;
    }

    public ComPacket getBodyPacket() {
        return this.bodyPacket;
    }

    public String toString() {
        if (this.tcpHeader != null) {
            return "packet status=" + (Object)((Object)this.status) + ", " + this.tcpHeader + ": " + ByteArrayLog.onlyHex(this.packetBody);
        }
        int id = 0;
        if (this.packetId != null) {
            id = this.packetId & 0xFF;
        }
        if (id == 0 && (this.packetCommand == null || this.packetCommand.isEmpty()) && this.packetBody.length == 1) {
            return String.format("0x%02X", this.packetBody[0]);
        }
        if (id == 0 && this.packetCommand == null) {
            return this.bodyToString().toString();
        }
        return "#" + String.format("%02X", id) + " " + this.packetCommand + " " + this.bodyToString();
    }

    private ByteArrayLog bodyToString() {
        if (this.status == STATUS.ENDTCP || this.status == STATUS.TCP) {
            return ByteArrayLog.onlyHex(this.packetBody);
        }
        return new ByteArrayLog(this.packetBody);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComPacket)) {
            return false;
        }
        ComPacket packet = (ComPacket)o;
        if (!Arrays.equals(this.packetBody, packet.packetBody)) {
            return false;
        }
        if (this.status != packet.status) {
            return false;
        }
        if (this.packetId != null ? !this.packetId.equals(packet.packetId) : packet.packetId != null) {
            return false;
        }
        if (this.packetCommand != null ? !this.packetCommand.equals(packet.packetCommand) : packet.packetCommand != null) {
            return false;
        }
        return !(this.tcpHeader != null ? !this.tcpHeader.equals(packet.tcpHeader) : packet.tcpHeader != null);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.packetBody);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.packetId != null ? this.packetId.hashCode() : 0);
        result = 31 * result + (this.packetCommand != null ? this.packetCommand.hashCode() : 0);
        result = 31 * result + (this.tcpHeader != null ? this.tcpHeader.hashCode() : 0);
        return result;
    }

    public static enum STATUS {
        PACKET,
        END,
        TCP,
        ENDTCP,
        ERROR;

    }
}

