/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.monitor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Level;
import org.comproxy.Main;
import org.comproxy.Version;
import org.comproxy.tcp.InternalExecutorApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorThread
extends Thread {
    public static final int MONITOR_PORT = 5321;
    public static final String STOP_CMD = "stopMonitor";
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    private final byte[] response;
    private ServerSocket providerSocket;
    private InternalExecutorApi executor = null;

    public MonitorThread(InternalExecutorApi pool) {
        this.executor = pool;
        this.response = ("{\"Version\": \"" + Version.getVersion() + "\"}").getBytes();
        try {
            this.providerSocket = new ServerSocket(5321, 10);
        }
        catch (Exception ex) {
            this.LOG.error(" Init TransportProvider error", ex);
        }
    }

    @Override
    public void run() {
        this.LOG.debug(" Start monitor wait thread");
        if (this.providerSocket != null) {
            this.LOG.debug(" Monitor wait thread ...");
            while (!Thread.interrupted()) {
                try {
                    this.waitRequest();
                }
                catch (InterruptedException ie) {
                    break;
                }
                catch (Exception e) {
                    if (Thread.interrupted()) break;
                    this.LOG.error(" ", e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        break;
                    }
                }
            }
            try {
                this.providerSocket.close();
                this.LOG.error("Socket closed");
            }
            catch (IOException e) {
                this.LOG.error("Error close socket", e);
            }
            finally {
                try {
                    this.providerSocket.close();
                }
                catch (IOException e) {
                    this.LOG.error("Error finally close socket", e);
                }
            }
        } else {
            this.LOG.error(" Cannot start monitor provider - socket is null");
        }
        this.LOG.info(" Monitor finished");
    }

    private void waitRequest() throws IOException, InterruptedException {
        Socket socket = this.providerSocket.accept();
        this.LOG.debug(" Request accepted");
        ReqJob toExecute = new ReqJob(socket);
        while (!Thread.interrupted()) {
            try {
                this.executor.submit(toExecute, "MonitorThreadRequest");
                break;
            }
            catch (RejectedExecutionException ree) {
                this.LOG.error(" Work queue is full, waiting");
                Thread.sleep(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startJob(Socket socket) {
        InputStream in = null;
        OutputStream out = null;
        try {
            byte[] response;
            Level level;
            this.LOG.debug(" Do monitor request job: {}", (Object)socket.getInetAddress());
            in = new BufferedInputStream(socket.getInputStream());
            String request = this.readInputHeaders(in);
            Map<String, String> params = this.getRequestParams(request);
            this.LOG.debug(" Monitor request:\n{}", (Object)request);
            String logLevel = params.get("log_level");
            if (logLevel != null && (level = Level.toLevel(logLevel)) != null) {
                Main.configureLogger(level, 4, true);
                this.LOG.warn("log level changed: {}", (Object)level);
            }
            if (params.get(STOP_CMD) != null) {
                this.LOG.info("Service stopMonitor");
                response = "{\r\nResult: stopped\r\n}".getBytes();
            } else {
                response = this.response;
            }
            out = new BufferedOutputStream(socket.getOutputStream());
            String respHeader = "HTTP/1.1 200 OK\nContent-Type: application/json\nContent-Length: " + response.length + "\n\n";
            out.write(respHeader.getBytes());
            out.write(response);
            out.flush();
            if (params.get(STOP_CMD) != null) {
                Main.stop(new String[0]);
                this.LOG.info("Service stopped");
            }
        }
        catch (Exception ex) {
            this.LOG.error("TransportProvider start job error", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
            try {
                socket.close();
            }
            catch (IOException ex) {
                this.LOG.error("TransportProvider socket close error", ex);
            }
        }
    }

    private Map<String, String> getRequestParams(String request) {
        int endIndex;
        HashMap<String, String> params = new HashMap<String, String>();
        int startIndex = request.indexOf("/");
        if (startIndex != -1 && (endIndex = request.indexOf(" HTTP", startIndex)) != -1) {
            String[] paramsSrc;
            String result = request.substring(startIndex + 1, endIndex);
            this.LOG.debug(" Request url: {}", (Object)result);
            for (String p : paramsSrc = result.split("&")) {
                String[] paramSrc = p.split("=");
                String paramValue = "";
                if (paramSrc.length == 2) {
                    paramValue = paramSrc[1];
                }
                params.put(paramSrc[0], paramValue);
            }
        }
        return params;
    }

    private String readInputHeaders(InputStream in) throws IOException {
        String s;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String header = "";
        while ((s = br.readLine()) != null && s.trim().length() != 0) {
            header = header + s + "\r\n";
        }
        return header;
    }

    private class ReqJob
    implements Runnable {
        private Socket socket;

        public ReqJob(Socket socket) {
            if (MonitorThread.this.LOG.isDebugEnabled()) {
                MonitorThread.this.LOG.debug(" Request from - {}, {}", (Object)socket.getRemoteSocketAddress(), (Object)socket.getInetAddress());
            }
            this.socket = socket;
        }

        @Override
        public void run() {
            MonitorThread.this.startJob(this.socket);
        }
    }
}

