/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.config.portFinder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import jssc.SerialPortList;
import org.comproxy.config.ProxyConfig;
import org.comproxy.config.portFinder.PortData;
import org.comproxy.config.portFinder.PortFinderThread;
import org.comproxy.config.portFinder.PortResult;

public class PortFinderFromListThread
extends PortFinderThread {
    public PortFinderFromListThread(ProxyConfig proxyConfig, String instanceId) {
        super(proxyConfig, instanceId);
    }

    @Override
    protected PortResult checkSerialNumberHardware(PortData portData) {
        this.LOG.debug("{} Try find port name for serial number {} ", (Object)this.instanceId, (Object)portData.getSerialNumber());
        PortResult portResult = null;
        List<String> ports = this.getPortList();
        this.LOG.debug("{} Try find port in portList {} ", (Object)this.instanceId, (Object)ports);
        for (String portName : ports) {
            portResult = this.checkPortBySerialNumberHardware(portData, portName);
            if (portResult == null) continue;
            return portResult;
        }
        return null;
    }

    private List<String> getPortList() {
        LinkedList<String> ports = new LinkedList<String>(Arrays.asList(SerialPortList.getPortNames()));
        if (!this.twoFrMode) {
            ports.remove(this.proxyConfig.getVirtualPortPrinter1());
            ports.remove(this.proxyConfig.getVirtualPortPrinter1Out());
        } else {
            ports.remove(this.proxyConfig.getVirtualPortPrinter1());
            ports.remove(this.proxyConfig.getVirtualPortPrinter1Out());
            ports.remove(this.proxyConfig.getVirtualPortPrinter2());
            ports.remove(this.proxyConfig.getVirtualPortPrinter2Out());
        }
        return ports;
    }
}

