/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlParser {
    private static final Logger LOG = LoggerFactory.getLogger(XmlParser.class);
    private static final String FILENAME = "ComProxy.xml";
    private static final String FR_NODE_NAME = "fiscal_printer";

    public String parse() {
        return this.parseSTAX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseSTAX() {
        FileInputStream fis = null;
        StringBuilder sb = new StringBuilder();
        try {
            if (!this.validateXml(new FileInputStream(FILENAME))) {
                throw new Exception("Invalid xml config file");
            }
            fis = new FileInputStream(FILENAME);
            XMLStreamReader xmlr = XMLInputFactory.newInstance().createXMLStreamReader(FILENAME, fis);
            String nodeName = "";
            String nodeData = "";
            String frNodeId = "0";
            while (xmlr.hasNext()) {
                xmlr.next();
                if (xmlr.isStartElement()) {
                    nodeName = xmlr.getLocalName();
                    if (nodeName.equals(FR_NODE_NAME)) {
                        frNodeId = xmlr.getAttributeValue(null, "id");
                    }
                } else if (xmlr.hasText() && xmlr.getText().trim().length() > 0) {
                    nodeData = xmlr.getText();
                    if (Integer.valueOf(frNodeId) > 1) {
                        nodeName = nodeName + frNodeId;
                    }
                    if (!nodeData.contains("<") | !nodeData.contains(">")) {
                        sb.append(nodeName + "=" + nodeData + "\n");
                    }
                }
                if (xmlr.isEndElement() && (nodeName = xmlr.getLocalName()).equals(FR_NODE_NAME)) {
                    nodeName = "";
                    frNodeId = "0";
                }
                nodeData = "";
            }
        }
        catch (Exception e) {
            LOG.error("XML Config error", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public boolean storeValueInXml(String itemName, String value) {
        try {
            int nodeIndex = 1;
            String xmlItemName = itemName;
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(FILENAME));
            if (itemName.endsWith("2")) {
                nodeIndex = 2;
                xmlItemName = itemName.substring(0, itemName.length() - 1);
            }
            if (itemName.endsWith("1")) {
                nodeIndex = 2;
                xmlItemName = itemName.substring(0, itemName.length() - 1);
            }
            Node frNode = doc.getElementsByTagName(FR_NODE_NAME).item(nodeIndex - 1);
            NodeList list = frNode.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!xmlItemName.equals(node.getNodeName())) continue;
                node.setTextContent(value);
                break;
            }
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(new DOMSource(doc), new StreamResult(new File(FILENAME)));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean validateXml(FileInputStream fileInputStream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new SimpleErrorHandler());
            Document document = builder.parse(new InputSource(fileInputStream));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public class SimpleErrorHandler
    implements ErrorHandler {
        @Override
        public void warning(SAXParseException e) throws SAXException {
            System.out.println(e.getMessage());
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            System.out.println(e.getMessage());
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            System.out.println(e.getMessage());
        }
    }
}

