/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.comproxy.SystemInfo;
import org.comproxy.config.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyConfig.class);
    private static final String VIRTUAL_BAUDRATE_PROP_F1 = "virtual_port_baudrate";
    private static final String VIRTUAL_BAUDRATE_PROP_F2 = "virtual_port_baudrate2";
    private static final String PHYSICAL_BAUDRATE_PROP_F1 = "physical_port_baudrate";
    private static final String PHYSICAL_BAUDRATE_PROP_F2 = "physical_port_baudrate2";
    private static final String VIRTUAL_PORT_PROP_F1 = "virtual_port";
    private static final String VIRTUAL_PORT_PROP_F2 = "virtual_port2";
    private static final String PHYSICAL_PORT_PROP_F1 = "physical_port";
    private static final String PHYSICAL_PORT_PROP_F2 = "physical_port2";
    private static final String VIRTUAL_PORT_OUT_PROP_F1 = "virtual_port_out";
    private static final String VIRTUAL_PORT_OUT_PROP_F2 = "virtual_port_out2";
    private static final String FR_CONNECTION_TYPE_F1 = "fr_connection_type";
    private static final String FR_CONNECTION_TYPE_F2 = "fr_connection_type2";
    private static final String START_POS_IP_F1 = "start_pos_ip";
    private static final String START_POS_IP_F2 = "start_pos_ip2";
    private static final String POS_TCP_PORT_FR1 = "pos_tcp_port";
    private static final String POS_TCP_PORT_FR2 = "pos_tcp_port2";
    private static final String FR_SERIAL_NUMBER1 = "fr_serial_number";
    private static final String FR_SERIAL_NUMBER2 = "fr_serial_number2";
    public static final String LOG_LEVEL_PROP = "log_level";
    private static final String FIND_PID_VID = "find_pid_vid";
    private static final String MAX_DAY_INDEX_PROP = "max_day_index";
    private static final String CREATE_ZIP_FLAG = "create_zip";
    private static final String START_AGENT = "start_agent";
    private static final String FAST_START = "fast_start";
    private static final String AGENT_DATA_PORT = "agent_data_port";
    private static final String USE_DNS_RESOLVING = "use_dns_resolving";
    private static final String DNS_RESOLVING_TIMEOUT = "dns_resolving_timeout";
    private static final String DNS_RESULT_LIFETIME = "dns_result_lifetime";
    private static final String DNS_INVALID_RESULT_LIFETIME = "dns_invalid_result_lifetime";
    private static final String SETTINGS_RESULT_LIFETIME = "settings_result_lifetime";
    private static final String COOL_DOWN_MODE_TIMEOUT = "cool_down_mode_timeout";
    private static final String COOL_DOWN_MODE_COUNTER = "cool_down_mode_counter";
    private static final boolean DEFAULT_USE_DNS_RESOLVING = true;
    public static final long DEFAULT_DNS_RESOLVING_TIMEOUT = TimeUnit.SECONDS.toSeconds(1L);
    public static final long DEFAULT_DNS_RESULT_LIFETIME = TimeUnit.HOURS.toSeconds(3L);
    public static final long DEFAULT_DNS_INVALID_RESULT_LIFETIME = TimeUnit.MINUTES.toSeconds(3L);
    public static final long DEFAULT_SETTINGS_RESULT_LIFETIME = TimeUnit.HOURS.toSeconds(4L);
    public static final long DEFAULT_COOL_DOWN_MODE_TIMEOUT = TimeUnit.MINUTES.toSeconds(5L);
    public static final int DEFAULT_COOL_DOWN_MODE_COUNTER = 5;
    private static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().contains("linux");
    private static final String DEFAULT_PHYSICAL_PORT_F1 = IS_LINUX ? "/dev/ttyUSB0" : "COM1";
    private static final String DEFAULT_PHYSICAL_PORT_F2 = IS_LINUX ? "/dev/ttyUSB1" : "COM2";
    private static final String DEFAULT_VIRTUAL_PORT_F1 = IS_LINUX ? "/dev/ttyS90" : "COM9";
    private static final String DEFAULT_VIRTUAL_PORT_F2 = IS_LINUX ? "/dev/ttyS100" : "COM11";
    private static final String DEFAULT_VIRTUAL_PORT_OUT_F1 = IS_LINUX ? "/dev/ttyS91" : "COM10";
    private static final String DEFAULT_VIRTUAL_PORT_OUT_F2 = IS_LINUX ? "/dev/ttyS101" : "COM12";
    private static final String DEFAULT_FR_SERIAL_NUMBER1 = "";
    private static final String DEFAULT_FR_SERIAL_NUMBER2 = "";
    private static final boolean DEFAULT_FIND_PID_VID = false;
    private static final boolean DEFAULT_START_AGENT = true;
    private static final boolean DEFAULT_FAST_START = true;
    private static final String DEFAULT_POS_TCP_PORT_FR1 = "50001";
    private static final String DEFAULT_POS_TCP_PORT_FR2 = "50002";
    private static final String DEFAULT_FR_CONNECTION_TYPE_F1 = "USB";
    private static final String DEFAULT_FR_CONNECTION_TYPE_F2 = "USB";
    private static final boolean DEFAULT_START_POS_IP_F1 = false;
    private static final boolean DEFAULT_START_POS_IP_F2 = false;
    private static final int DEFAULT_PHYSICAL_BAUDRATE_F1 = 57600;
    private static final int DEFAULT_PHYSICAL_BAUDRATE_F2 = 57600;
    private static final int DEFAULT_VIRTUAL_BAUDRATE_F1 = 57600;
    private static final int DEFAULT_VIRTUAL_BAUDRATE_F2 = 57600;
    private static final Level DEFAULT_LOG_LEVEL = Level.ERROR;
    public static final int DEFAULT_MAX_DAY_INDEX = 4;
    public static final boolean DEFAULT_CREATE_ZIP = true;
    private static final int DEFAULT_AGENT_DATA_PORT = 9998;
    private Properties prop;
    private XmlParser xmlParser;
    private String homePathFile;
    private String homePath;
    private boolean loadXmlFailed = false;
    private boolean loadXmlDefault = false;
    private boolean winOS = true;

    public ProxyConfig(String homePath, String configFileName) {
        this.homePath = homePath;
        this.winOS = !new SystemInfo().isLinux();
        this.homePathFile = homePath + File.separator + configFileName;
        this.prop = new Properties();
        this.xmlParser = new XmlParser();
        File file = new File(this.homePathFile);
        if (file.exists()) {
            try {
                this.prop.load(new FileReader(file));
            }
            catch (IOException e) {
                LOG.error("Load config failed", e);
            }
        } else {
            this.loadXmlFailed = true;
            String f = this.xmlParser.parse();
            if (!f.equals("")) {
                try {
                    this.prop.load(new InputStreamReader(new ByteArrayInputStream(f.getBytes())));
                    this.loadXmlFailed = false;
                }
                catch (IOException e) {
                    LOG.error("Load config failed", e);
                }
            } else {
                this.addDefaultProperties();
                LOG.error("Load config failed, load default config ");
                this.loadXmlDefault = true;
                try {
                    this.prop.store(new FileWriter(file), "ComProxy configuration file");
                }
                catch (IOException e) {
                    LOG.error("Save default config failed", e);
                }
            }
        }
    }

    public ProxyConfig(String file) {
        this.prop = new Properties();
        if (file != null) {
            try {
                this.prop.load(new ByteArrayInputStream(file.getBytes()));
            }
            catch (IOException e) {
                LOG.error("Load config failed", e);
            }
        } else {
            this.addDefaultProperties();
            try {
                this.prop.store(new FileWriter(file), "ComProxy configuration file");
            }
            catch (IOException e) {
                LOG.error("Save default config failed", e);
            }
        }
    }

    private void addDefaultProperties() {
        this.prop.setProperty(PHYSICAL_PORT_PROP_F1, DEFAULT_PHYSICAL_PORT_F1);
        this.prop.setProperty(PHYSICAL_BAUDRATE_PROP_F1, String.valueOf(57600));
        this.prop.setProperty(PHYSICAL_PORT_PROP_F2, DEFAULT_PHYSICAL_PORT_F2);
        this.prop.setProperty(PHYSICAL_BAUDRATE_PROP_F2, String.valueOf(57600));
        this.prop.setProperty(VIRTUAL_PORT_PROP_F1, DEFAULT_VIRTUAL_PORT_F1);
        this.prop.setProperty(VIRTUAL_PORT_OUT_PROP_F1, DEFAULT_VIRTUAL_PORT_OUT_F1);
        this.prop.setProperty(VIRTUAL_BAUDRATE_PROP_F1, String.valueOf(57600));
        this.prop.setProperty(VIRTUAL_PORT_PROP_F2, DEFAULT_VIRTUAL_PORT_F2);
        this.prop.setProperty(VIRTUAL_PORT_OUT_PROP_F2, DEFAULT_VIRTUAL_PORT_OUT_F2);
        this.prop.setProperty(VIRTUAL_BAUDRATE_PROP_F2, String.valueOf(57600));
        this.prop.setProperty(FR_CONNECTION_TYPE_F1, "USB");
        this.prop.setProperty(FR_CONNECTION_TYPE_F2, "USB");
        this.prop.setProperty(LOG_LEVEL_PROP, DEFAULT_LOG_LEVEL.toString());
        this.prop.setProperty(MAX_DAY_INDEX_PROP, String.valueOf(4));
        this.prop.setProperty(CREATE_ZIP_FLAG, String.valueOf(true));
        this.prop.setProperty(START_AGENT, String.valueOf(true));
    }

    public boolean isLoadXmlFailed() {
        return this.loadXmlFailed;
    }

    public boolean isLoadXmlDefault() {
        return this.loadXmlDefault;
    }

    public String getHomePath() {
        return this.homePath;
    }

    public String getPhysicalPortPrinter1() {
        String portName = this.prop.getProperty(PHYSICAL_PORT_PROP_F1, DEFAULT_PHYSICAL_PORT_F1).trim();
        if (this.winOS) {
            return portName.toUpperCase();
        }
        return portName;
    }

    public String getPhysicalPortPrinter2() {
        String portName = this.prop.getProperty(PHYSICAL_PORT_PROP_F2) != null ? this.prop.getProperty(PHYSICAL_PORT_PROP_F2).trim() : "";
        if (this.winOS) {
            return portName.toUpperCase();
        }
        return portName;
    }

    public String getVirtualPortPrinter1() {
        return this.prop.getProperty(VIRTUAL_PORT_PROP_F1, DEFAULT_VIRTUAL_PORT_F1).trim();
    }

    public String getVirtualPortPrinter2() {
        if (this.prop.getProperty(VIRTUAL_PORT_PROP_F2) != null) {
            return this.prop.getProperty(VIRTUAL_PORT_PROP_F2).trim();
        }
        return "";
    }

    public void getPhysicalPortPrinter1(String physicalPortProp) {
        this.prop.setProperty(PHYSICAL_PORT_PROP_F1, physicalPortProp);
    }

    public void setPhysicalPortPrinter2(String physicalPortProp) {
        this.prop.setProperty(PHYSICAL_PORT_PROP_F2, physicalPortProp);
    }

    public String getVirtualPortPrinter1Out() {
        return this.prop.getProperty(VIRTUAL_PORT_OUT_PROP_F1, DEFAULT_VIRTUAL_PORT_OUT_F1).trim();
    }

    public String getVirtualPortPrinter2Out() {
        return this.prop.getProperty(VIRTUAL_PORT_OUT_PROP_F2, DEFAULT_VIRTUAL_PORT_OUT_F2).trim();
    }

    public String getPrinterSerialNumber1() {
        return this.prop.getProperty(FR_SERIAL_NUMBER1, "").trim();
    }

    public String getPrinterSerialNumber2() {
        return this.prop.getProperty(FR_SERIAL_NUMBER2, "").trim();
    }

    private int getIntProperty(String key, int defaultValue) {
        String value = this.prop.getProperty(key, String.valueOf(defaultValue));
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private long getLongProperty(String key, long defaultValue) {
        String value = this.prop.getProperty(key, String.valueOf(defaultValue));
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private String getConnectionTypeOfPrinter1() {
        return this.prop.getProperty(FR_CONNECTION_TYPE_F1, "USB").trim();
    }

    private String getConnectionTypeOfPrinter2() {
        return this.prop.getProperty(FR_CONNECTION_TYPE_F2, "USB").trim();
    }

    public String getPosTcpPortFr1() {
        return this.prop.getProperty(POS_TCP_PORT_FR1, DEFAULT_POS_TCP_PORT_FR1).trim();
    }

    public String getPosTcpPortFr2() {
        return this.prop.getProperty(POS_TCP_PORT_FR2, DEFAULT_POS_TCP_PORT_FR2).trim();
    }

    public boolean isUSBconnectionOfPrinter1() {
        return this.getConnectionTypeOfPrinter1().equalsIgnoreCase("USB");
    }

    public boolean isUSBconnectionOfPrinter2() {
        return this.getConnectionTypeOfPrinter2().equalsIgnoreCase("USB");
    }

    private boolean getBoolProperty(String key, boolean defaultValue) {
        String value = this.prop.getProperty(key, String.valueOf(defaultValue));
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getPhysicalSpeedPrinter1() {
        return this.getIntProperty(PHYSICAL_BAUDRATE_PROP_F1, 57600);
    }

    public int getPhysicalSpeedPrinter2() {
        return this.getIntProperty(PHYSICAL_BAUDRATE_PROP_F2, 57600);
    }

    public int getVirtualSpeedPrinter1() {
        return this.getIntProperty(VIRTUAL_BAUDRATE_PROP_F1, 57600);
    }

    public int getVirtualSpeedPrinter2() {
        return this.getIntProperty(VIRTUAL_BAUDRATE_PROP_F2, 57600);
    }

    public boolean getStartPosIp1() {
        return this.getBoolProperty(START_POS_IP_F1, false);
    }

    public boolean getStartPosIp2() {
        return this.getBoolProperty(START_POS_IP_F2, false);
    }

    public int getBufferSize() {
        return this.getIntProperty("buffer_size", 0);
    }

    public Level getLogLevel() {
        String logLevel = this.prop.getProperty(LOG_LEVEL_PROP, DEFAULT_LOG_LEVEL.toString());
        return Level.toLevel(logLevel, Level.ERROR);
    }

    public int getAgentDataPort() {
        return this.getIntProperty(AGENT_DATA_PORT, 9998);
    }

    public int getMaxDayIndex() {
        return this.getIntProperty(MAX_DAY_INDEX_PROP, 4);
    }

    public boolean getCreateZip() {
        return this.getBoolProperty(CREATE_ZIP_FLAG, true);
    }

    public boolean isStartAgent() {
        return this.getBoolProperty(START_AGENT, true) || this.isLocalAgent();
    }

    public boolean isLocalAgent() {
        return "local".equals(this.prop.getProperty(START_AGENT));
    }

    public boolean isFastStart() {
        return this.getBoolProperty(FAST_START, true);
    }

    public boolean getFindPidVid() {
        return this.getBoolProperty(FIND_PID_VID, false);
    }

    public boolean useDnsResolving() {
        return this.getBoolProperty(USE_DNS_RESOLVING, true);
    }

    public long getDnsResolvingTimeout() {
        return this.getLongProperty(DNS_RESOLVING_TIMEOUT, DEFAULT_DNS_RESOLVING_TIMEOUT);
    }

    public long getDnsResultLifetime() {
        return this.getLongProperty(DNS_RESULT_LIFETIME, DEFAULT_DNS_RESULT_LIFETIME);
    }

    public long getDnsInvalidResultLifetime() {
        return this.getLongProperty(DNS_INVALID_RESULT_LIFETIME, DEFAULT_DNS_INVALID_RESULT_LIFETIME);
    }

    public long getSettingsResultLifetime() {
        return this.getLongProperty(SETTINGS_RESULT_LIFETIME, DEFAULT_SETTINGS_RESULT_LIFETIME);
    }

    public long getCoolDownModeTimeout() {
        return this.getLongProperty(COOL_DOWN_MODE_TIMEOUT, DEFAULT_COOL_DOWN_MODE_TIMEOUT);
    }

    public int getCoolDownModeCounter() {
        return this.getIntProperty(COOL_DOWN_MODE_COUNTER, 5);
    }

    public String toString() {
        return "ProxyConfig: \n " + this.prop.toString().replace(", ", "\n  ");
    }
}

