/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxConnectorChecker {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxConnectorChecker.class);
    private static String linuxPathSerial = "/sys/bus/usb/devices";

    public static String chekPiritLinuxConnection() {
        String result = "";
        File serialFolder = new File(linuxPathSerial);
        LOG.trace("DevicesFolder exist - {}", (Object)serialFolder.exists());
        if (serialFolder.exists()) {
            File[] listOfDevices = serialFolder.listFiles();
            block2: for (int i = 0; i < listOfDevices.length; ++i) {
                LOG.trace("Device - {} " + listOfDevices[i].getName());
                File uevent = new File(listOfDevices[i].getAbsolutePath() + "/uevent");
                if (uevent.exists()) {
                    try {
                        LOG.trace("Uevent file exist - {} ", (Object)"");
                        Scanner e = new Scanner(uevent.getAbsoluteFile());
                        while (e.hasNextLine()) {
                            boolean existProduct = false;
                            String line = e.nextLine();
                            if (line.startsWith("PRODUCT=483/5740/")) {
                                existProduct = true;
                                LOG.trace("Product exist - {} ", (Object)"");
                                File tty = new File(listOfDevices[i].getAbsolutePath() + "/tty");
                                if (tty.exists()) {
                                    File[] listTTY = tty.listFiles();
                                    if (listTTY.length > 0) {
                                        result = "/dev/" + listTTY[0].getName();
                                        continue block2;
                                    }
                                    LOG.trace("No device name in current device folder - {} ", (Object)"");
                                } else {
                                    LOG.trace("No device folder in current device folder - {} ", (Object)"");
                                }
                            }
                            if (existProduct) continue;
                            LOG.trace("No product PID VID in current device folder - {} ", (Object)"");
                        }
                        continue;
                    }
                    catch (FileNotFoundException var11) {
                        var11.printStackTrace();
                        continue;
                    }
                }
                LOG.trace("No uevent file in current device folder - {} ", (Object)"");
            }
        }
        LOG.trace("Device path is - {}", (Object)result);
        return result;
    }

    public static boolean checkPidVidPiritLinuxConnection() {
        return !LinuxConnectorChecker.chekPiritLinuxConnection().equals("");
    }
}

