/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.com.serialio;

import java.util.concurrent.ConcurrentLinkedQueue;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import org.comproxy.com.serialio.CommonPortReader;
import org.comproxy.com.serialio.CommonSerialPort;
import org.slf4j.Logger;

public class PortReaderJssc
implements SerialPortEventListener,
CommonPortReader {
    private CommonSerialPort serialPort;
    private final Runnable signal;
    private final Logger log;
    private byte[] buffer;
    private ConcurrentLinkedQueue<byte[]> readDataQueue;

    public PortReaderJssc(CommonSerialPort serialPort, Runnable signal, Logger log) {
        this.serialPort = serialPort;
        this.signal = signal;
        this.log = log;
        this.readDataQueue = new ConcurrentLinkedQueue();
    }

    @Override
    public void serialEvent(SerialPortEvent event) {
        if (!event.isRXCHAR() || event.getEventValue() <= 0) {
            return;
        }
        try {
            byte[] tmp = this.serialPort.readBytes();
            if (tmp != null) {
                this.readDataQueue.add(tmp);
                this.signal.run();
            } else {
                this.log.info("C() tmp==null");
            }
        }
        catch (Exception ex) {
            this.log.error("Error in serialEvent COM-portFinder", ex);
        }
    }

    @Override
    public synchronized boolean isHaveData() {
        return !this.readDataQueue.isEmpty();
    }

    @Override
    public synchronized byte[] getBuffer() {
        try {
            if (!this.readDataQueue.isEmpty()) {
                this.buffer = this.readDataQueue.poll();
            }
        }
        catch (Exception e) {
            this.log.error("getBuffer result error: {}", (Object)e.getMessage());
        }
        return this.buffer;
    }
}

