/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.com.classic;

import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.comproxy.ProxyModel;
import org.comproxy.SingleComProxyApiImpl;
import org.comproxy.com.ComConnector;
import org.comproxy.com.classic.ComThreadBase;
import org.comproxy.reader.ByteArray;
import org.comproxy.reader.ComPacket;
import org.comproxy.reader.PackageReader;
import org.comproxy.reader.PackageReaderListener;
import org.comproxy.utils.ComUtils;
import ru.crystals.utils.time.Timer;

public class VirtualComThread
extends ComThreadBase
implements Runnable,
PackageReaderListener {
    private boolean sendAckForImage = false;

    public VirtualComThread(ProxyModel model) {
        this.model = model;
        this.packageReader = new PackageReader(true, this);
        this.init(model::signalVirtual);
    }

    @Override
    ComConnector getConnector() {
        return this.model.getVirtualConnector();
    }

    @Override
    protected void readData(int read, byte[] buffer) throws InterruptedException {
        if (this.model.isSendImageMode() && this.model.getRestImageSize().get() > 0) {
            this.model.resetImageModeTimeOut();
            this.log.debug("--> <binary data {} bytes>", (Object)read);
            byte[] readBytes = Arrays.copyOf(buffer, read);
            int restBytes = this.model.getRestImageSize().addAndGet(-readBytes.length);
            this.log.debug("Rest image bytes: {}", (Object)restBytes);
            if (restBytes < 0) {
                this.model.getRestImageSize().set(0);
            }
            this.model.getImageBuffer().offer(new ByteArray(readBytes));
            this.model.signalPhysical();
        } else {
            super.readData(read, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.model.setLogMarkMdc();
        this.readyForPos();
        byte[] buffer = new byte[4096];
        while (!Thread.interrupted()) {
            try {
                ComPacket packet;
                this.model.waitForFRConnected();
                boolean needPause = this.readFromConnector(this.model.getVirtualConnector(), buffer);
                while (!Thread.interrupted() && (packet = this.model.getPacketToVirtual()) != null) {
                    String packetCommand = packet.getPacketCommand();
                    if ("21".equals(packetCommand)) {
                        this.model.getSettings().setShiftOpened(false);
                        this.model.sendCommandToPhysical(ProxyModel.makeGetDevInfoComPacket());
                    } else if (!this.model.getSettings().isShiftOpened() && ("58".equals(packetCommand) || "30".equals(packetCommand))) {
                        this.model.sendCommandToPhysical(ProxyModel.makeGetDevInfoComPacket());
                    } else if ("23".equals(packetCommand)) {
                        this.model.getSettings().setShiftOpened(false);
                        this.model.sendCommandToPhysical(ProxyModel.makeGetDevInfoComPacket());
                    }
                    if (this.isImageCommand(packet)) {
                        this.model.setSendImageMode(false);
                        this.sendAckForImage = false;
                    }
                    if (this.model.isSendImageMode() && packet.testCommand((byte)6) && !this.sendAckForImage) {
                        this.sendToConnector(packet);
                        this.sendAckForImage = true;
                        this.log.debug("Service start transmit image");
                    } else {
                        this.sendToConnector(packet);
                    }
                    if (packet.getPacketCommand() == null) continue;
                    this.sendToAgent(packet);
                    needPause = false;
                }
                if (!needPause) continue;
                this.model.getVirtualThreadReadyLock().lock();
                try {
                    if (this.model.hasPacketToVirtual()) {
                        this.log.trace("skip await hasPacket=true");
                        continue;
                    }
                    if (this.isHaveData()) {
                        this.log.trace("skip await haveData=true");
                        this.model.getVirtualDataAvailable().await(100L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    this.model.getVirtualDataAvailable().await();
                }
                finally {
                    this.model.getVirtualThreadReadyLock().unlock();
                }
            }
            catch (InterruptedException ie) {
                break;
            }
            catch (Exception e) {
                this.log.error("", e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    break;
                }
            }
        }
        this.log.trace("Virtual finished");
    }

    private void readyForPos() {
        Timer timer = Timer.of(Duration.ofSeconds(3L));
        while (timer.isNotExpired() && !this.model.getSettings().isAllRequested()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        this.log.trace("Virtual started");
    }

    private void sendToAgent(ComPacket packet) {
        if (!this.model.isStartAgent()) {
            return;
        }
        SingleComProxyApiImpl comProxyApi = this.model.getComProxyApi();
        if (comProxyApi != null) {
            comProxyApi.onCommandFromDevice(packet);
        }
    }

    @Override
    public void command(ComPacket result) {
        this.log.debug("--> {}", (Object)result);
        if ((this.model.isTcpReadMode() || this.model.isCheckMarkMode() || this.model.isFnKeyMode() || this.model.isFrReadyForImage()) && this.sendAutoAnswer(result)) {
            return;
        }
        if (this.model.isTcpReadMode()) {
            if (this.model.isTcpSendInProcess() && (result.testCommand((byte)5) || this.model.isFnSafeCommand(result))) {
                this.log.trace("Safe command allowed during TCP exchange");
            } else {
                this.model.turnOffTcpReadMode();
            }
        }
        if (this.isImageCommand(result)) {
            this.model.setSendImageMode(true);
            int expectedImageSize = this.extractImagesSize(result);
            this.log.debug("expectedImageSize ({})", (Object)expectedImageSize);
            this.model.getRestImageSize().set(expectedImageSize);
            this.log.debug("<-- ACK (auto answer on image command)");
            this.model.sendCommandToVirtual(ComPacket.ACK_PACKET);
            this.model.sendFirstStopTcp("Image mode");
        }
        this.model.onNewVirtualCommand(result.getPacketCommand());
        this.model.getSettings().addUserRequest(result);
        this.model.sendCommandToPhysical(result);
    }

    private boolean sendAutoAnswer(ComPacket result) {
        if (result.testCommand((byte)5)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.log.debug("0x05 (auto answer)");
            this.model.sendCommandToVirtual(ComPacket.ACK_PACKET);
            return true;
        }
        if (result.getPacketCommand() != null && this.model.isAutoAnswerMode()) {
            if (result.getPacketCommand().equals("04")) {
                this.log.debug("Printer state = {} (auto answer)", (Object)this.model.getDeviceStatus());
                this.model.sendCommandToVirtual(this.makeResponse(result, "04", this.model.getDeviceStatus()));
                return true;
            }
            if (result.getPacketCommand().equals("81")) {
                this.log.debug("Money drawer state = {} (auto answer)", (Object)this.model.getCashDrawerStatus());
                this.model.sendCommandToVirtual(this.makeResponse(result, "81", this.model.getCashDrawerStatus()));
                return true;
            }
        }
        return false;
    }

    private ComPacket makeResponse(ComPacket result, String command, int state) {
        return new ComPacket(ComUtils.makePiritCommand(result.getPacketId(), command, "00", String.valueOf(state)), ComPacket.STATUS.PACKET, result.getPacketId(), command);
    }

    private int extractImagesSize(ComPacket result) {
        if (result.getPacketCommand().equals("55") || result.getPacketCommand().equals("18")) {
            int width = Integer.parseInt(result.getPacketValueByIndex(0).substring(2));
            int height = Integer.parseInt(result.getPacketValueByIndex(1));
            int xw = width / 8;
            if (width % 8 == 0) {
                return xw * height;
            }
            return (xw + 1) * height;
        }
        return Integer.parseInt(result.getPacketValueByIndex(0).substring(2));
    }
}

