/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.com.classic;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import jssc.SerialPortException;
import org.comproxy.Mode;
import org.comproxy.ProxyModel;
import org.comproxy.SettingsManager;
import org.comproxy.SingleComProxyApiImpl;
import org.comproxy.com.ComConnector;
import org.comproxy.com.classic.ComThreadBase;
import org.comproxy.reader.ByteArray;
import org.comproxy.reader.ComPacket;
import org.comproxy.reader.PackageReader;
import org.comproxy.reader.PackageReaderListener;
import org.comproxy.reader.TcpHeader;

public class PhysicalComThread
extends ComThreadBase
implements Runnable,
PackageReaderListener {
    private final AtomicReference<Mode> lastCoolDownMode = new AtomicReference();

    public PhysicalComThread(ProxyModel model) {
        this.model = model;
        this.packageReader = new PackageReader(false, this);
        this.init(model::signalPhysical);
    }

    @Override
    ComConnector getConnector() {
        return this.model.getPhysicalConnector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.model.setLogMarkMdc();
        this.log.trace("Physical started");
        this.model.sendCheckKKTVersion();
        SettingsManager settings = this.model.getSettings();
        settings.requestAll();
        byte[] buffer = new byte[4096];
        while (!Thread.interrupted()) {
            try {
                if (this.waitForReady()) break;
                boolean needPause = this.readFromConnector(this.getConnector(), buffer);
                if (this.model.isExclusiveModeActive()) {
                    this.model.deactivateExpiredModes();
                    if (!needPause) continue;
                    Thread.sleep(50L);
                    continue;
                }
                if (!(this.model.isExclusiveModeActive() || this.model.isTcpSendInProcess() || this.model.isSendImageMode())) {
                    ComPacket packetToSend = this.model.getSettings().getPacketToSend();
                    if (packetToSend != null) {
                        this.model.onNewVirtualCommand(packetToSend.getPacketCommand());
                        this.model.sendFirstCommandToPhysical(packetToSend, "settings");
                    } else {
                        ComPacket fromAgent = this.model.getPacketFromAgent();
                        if (fromAgent != null) {
                            this.model.onNewVirtualCommand(fromAgent.getPacketCommand());
                            this.model.sendCommandToPhysical(fromAgent);
                        }
                    }
                }
                needPause = this.processPacket(needPause);
                if (this.model.isSendImageMode() && this.model.isFrReadyForImage()) {
                    ByteArray bufferObj;
                    if (this.model.isImageModeExpired()) {
                        this.log.debug("Image mode expired");
                        this.model.setSendImageMode(false);
                        continue;
                    }
                    if (this.model.getImageBuffer().isEmpty() || (bufferObj = this.model.pollImageBuffer()) == null) continue;
                    this.model.resetImageModeTimeOut();
                    this.log.debug("IMAGE TRANSMIT  - : size {}", (Object)this.model.getImageBuffer().size());
                    this.sendImageBuffer(bufferObj);
                    continue;
                }
                if (needPause) {
                    ComPacket response;
                    while ((response = this.model.getTcpResponsePacket()) != null) {
                        this.sendToConnector(response);
                        Thread.sleep(100L);
                        this.sendToConnector(response.getBodyPacket());
                    }
                }
                if (!needPause) continue;
                this.model.getComThreadReadyLock().lock();
                try {
                    if (!this.model.getHardwareChecker().isFiscalPrinterConnected()) continue;
                    boolean hasPacket = this.model.hasPacketToPhysic();
                    boolean hasFromAgent = this.model.hasFromAgent();
                    if (hasPacket || hasFromAgent) {
                        this.log.trace("skip await hasPacket={} hasFromAgent={}", (Object)hasPacket, (Object)hasFromAgent);
                        continue;
                    }
                    if (this.isHaveData()) {
                        this.log.trace("skip await  haveData=true");
                        this.model.getDataAvailable().await(100L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    if (this.model.isExclusiveModeActive() || this.model.isTcpSendInProcess() || this.model.isSendImageMode()) {
                        this.model.getDataAvailable().await(100L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    this.log.trace("await");
                    this.model.getDataAvailable().await();
                }
                finally {
                    this.model.getComThreadReadyLock().unlock();
                }
            }
            catch (InterruptedException ie) {
                break;
            }
            catch (Exception e) {
                this.log.error("", e);
                try {
                    this.log.debug("sleep 1000");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    break;
                }
            }
        }
        this.log.debug("Physical finished");
    }

    private boolean waitForReady() throws Exception {
        if (this.model.getHardwareChecker().isFiscalPrinterConnected()) {
            return false;
        }
        if (this.model.getHardwareChecker().isStarted()) {
            return this.reconnect();
        }
        return false;
    }

    private boolean reconnect() throws Exception {
        if (this.getConnector().getSerialPort().isOpened()) {
            try {
                this.getConnector().getSerialPort().closePort();
                this.log.info("closePort {} ", (Object)this.getConnector().getPortName());
            }
            catch (SerialPortException e) {
                this.log.error("{} error closePort", (Object)this.getConnector().getPortName(), (Object)e);
            }
        }
        this.model.waitForFRConnected();
        this.model.sendCheckKKTVersion();
        if (this.model.getHardwareChecker().isNeedChangeMode()) {
            Thread.sleep(1000L);
            return true;
        }
        this.getConnector().reconnect();
        this.init(this.model::signalPhysical);
        SingleComProxyApiImpl comProxyApi = this.model.getComProxyApi();
        if (comProxyApi != null) {
            comProxyApi.onReconnect();
        }
        return false;
    }

    private boolean processPacket(boolean needPause) throws Exception {
        ComPacket packet;
        boolean result = needPause;
        while (!Thread.interrupted() && (packet = this.model.pollPacketToPhysic()) != null) {
            String cmd = packet.getPacketCommand();
            if (!(packet.testCommand((byte)19) || packet.testCommand((byte)6) || !this.model.isNoTcpModeTimeoutExpired() || this.model.isAutoAnswerMode() && this.model.isNotStatusCommand(cmd))) {
                this.log.debug("stop TCP");
                this.sendToConnector(ComPacket.DC3_PACKET);
            }
            if (!this.model.isTcpReadMode() && packet.testCommand((byte)6)) {
                this.log.debug("skip ACK");
            } else if (this.isImageCommand(packet)) {
                this.log.debug("Detected command 0x{} from KKT  - start image mode", (Object)cmd);
                this.model.setSendImageMode(true);
                int restSize = this.model.getRestImageSize().get();
                if (restSize == 0) {
                    this.sendToConnector(packet);
                } else if (!this.model.isImageModeExpired()) {
                    this.log.debug("Waiting for image loaded {}", (Object)restSize);
                    this.model.sendFirstCommandToPhysical(packet, "image");
                    Thread.sleep(100L);
                } else {
                    this.log.debug("Waiting for image loaded expired {}", (Object)restSize);
                    this.model.setSendImageMode(false);
                }
            } else {
                if (this.model.isCheckMarkCommand(packet)) {
                    this.model.setCheckMarkMode(true, packet.getPacketId());
                    this.sendToConnector(packet);
                    break;
                }
                if (this.model.isFnKeyModeCommand(packet)) {
                    this.model.setFnKeyMode(true, packet);
                    this.sendToConnector(packet);
                    this.model.getSettings().requestAll(packet);
                    break;
                }
                this.sendToConnector(packet);
            }
            result = false;
        }
        return result;
    }

    private void sendImageBuffer(ByteArray bufferObj) throws Exception {
        byte[] buffer = bufferObj.getBytes();
        long time = System.currentTimeMillis();
        this.getConnector().write(buffer);
        this.log.debug("IMAGE ({}) <-- {} bytes", (Object)(System.currentTimeMillis() - time), (Object)buffer.length);
    }

    @Override
    public void command(ComPacket result) {
        this.log.debug("--> {}", (Object)result);
        this.model.resetKktAnswerTimeout();
        if (result.testCommand((byte)5)) {
            this.onENQ();
            return;
        }
        if (result.getStatus() == ComPacket.STATUS.END) {
            this.onRegularPacket(result);
            return;
        }
        if (result.getStatus() == ComPacket.STATUS.ENDTCP) {
            this.onTCPPacket(result);
        }
    }

    private void onTCPPacket(ComPacket result) {
        if (this.model.isCheckMarkMode()) {
            this.model.resetCheckMarkTimeout();
            this.onCheckMarkTCPPacket(result);
            this.model.setAutoAnswerMode(false);
            return;
        }
        if (this.model.isFnKeyMode()) {
            this.model.resetFnKeyTimeOut();
            this.onFnKeyTCPPacket(result);
            return;
        }
        if (!result.checkTcpCrc()) {
            this.log.info("tcp crc fail");
            this.model.sendCommandToPhysical(ComPacket.NAK_PACKET);
            return;
        }
        if (this.model.isTcpSendInProcess()) {
            this.log.info("skip tcp because tcp already in process");
            return;
        }
        TcpHeader tcpHeader = result.getTcpHeader();
        Mode coolDownMode = this.model.getModeManager().getCoolDownMode(tcpHeader.getDstIp(), tcpHeader.getDstPort());
        Mode lastMode = this.lastCoolDownMode.getAndSet(coolDownMode);
        if (coolDownMode.isNotExpired()) {
            if (lastMode == null) {
                this.log.debug("skip tcp because of cool down mode for {}", (Object)coolDownMode.getModeName());
                this.model.sendFirstCommandToPhysical(ComPacket.DC3_PACKET);
            } else if (lastMode == coolDownMode) {
                this.log.debug("skip tcp because of cool down mode for {}", (Object)coolDownMode.getModeName());
                this.model.sendFailTcpCommandToPhysic();
            } else if (lastMode.isNotExpired()) {
                this.log.debug("skip tcp because of cool down mode for {} and {}", (Object)coolDownMode.getModeName(), (Object)lastMode.getModeName());
                this.model.sendFailTcpCommandToPhysic();
            } else {
                this.log.debug("skip tcp because of cool down mode for {}", (Object)coolDownMode.getModeName());
                this.model.sendFirstCommandToPhysical(ComPacket.DC3_PACKET);
            }
            this.model.setAutoAnswerMode(false);
            return;
        }
        this.model.sendCommandToPhysical(ComPacket.ACK_PACKET);
        this.model.sendCommandToTCP(result);
    }

    private void onCheckMarkTCPPacket(ComPacket result) {
        try {
            this.sendToConnector(ComPacket.ACK_PACKET);
        }
        catch (Exception e) {
            this.log.error("Error on send ACK", e);
            this.model.setCheckMarkMode(false, null);
            return;
        }
        ComPacket response = this.model.getTcpService().sendToOism(result);
        if (!this.model.isCheckMarkMode()) {
            this.log.error("Not in check mark mode");
            return;
        }
        try {
            this.sendToConnector(response);
        }
        catch (Exception e) {
            this.log.error("Error on send TCP response", e);
            this.model.setCheckMarkMode(false, null);
        }
    }

    private void onFnKeyTCPPacket(ComPacket result) {
        try {
            this.sendToConnector(ComPacket.ACK_PACKET);
        }
        catch (Exception e) {
            this.log.error("Error on send ACK", e);
            this.model.setFnKeyMode(false, null);
            return;
        }
        ComPacket response = this.model.getTcpService().sendToOkp(result);
        if (!this.model.isFnKeyMode()) {
            this.log.error("Not in fn key mode");
            return;
        }
        try {
            this.sendToConnector(response);
        }
        catch (Exception e) {
            this.log.error("Error on send TCP response", e);
            this.model.setFnKeyMode(false, null);
        }
    }

    private void onRegularPacket(ComPacket result) {
        if (this.model.processResponseOnExclusiveMode(result)) {
            this.model.sendCommandToVirtual(result);
            return;
        }
        if (this.model.isSendImageMode() && result.testCommand((byte)6)) {
            this.model.setFrReadyForImage(true);
            return;
        }
        if (result.getPacketCommand().equals("84")) {
            this.log.debug("Skip command to virtual");
            if (!result.isSuccessResponse()) {
                this.log.error("Error on write TCP response to device ({}):\n{}", (Object)result.getErrorCodeValue(), (Object)result);
            }
            return;
        }
        if (this.isImageCommand(result)) {
            if (!result.isSuccessResponse()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.model.setSendImageMode(false);
        }
        if (this.model.getSettings().processResponse(result)) {
            this.model.signalPhysical();
            this.model.signalVirtual();
            return;
        }
        SingleComProxyApiImpl comProxyApi = this.model.getComProxyApi();
        if (comProxyApi != null && comProxyApi.toAgent(result)) {
            return;
        }
        this.saveAutoAnswerValues(result);
        this.model.sendCommandToVirtual(result);
    }

    private void onENQ() {
        if (this.model.isExclusiveModeActive()) {
            try {
                this.sendToConnector(ComPacket.ACK_PACKET);
            }
            catch (Exception exception) {
                this.log.error("{}", (Object)exception.getMessage());
            }
            return;
        }
        if (this.model.isSendImageMode()) {
            this.log.trace("Ignore ENQ (image mode)");
            return;
        }
        if (this.model.isTcpSendInProcess()) {
            this.model.sendFirstStopTcp("TCP exchange in progress");
            return;
        }
        this.model.trySwitchToTCPMode();
        if (this.model.isTcpReadMode()) {
            this.model.sendCommandToPhysical(ComPacket.ACK_PACKET);
            this.model.setAutoAnswerMode(true);
        } else {
            this.model.sendFirstStopTcp("");
        }
    }

    private void saveAutoAnswerValues(ComPacket result) {
        int newStatus;
        if (result.getPacketCommand().equals("04") && (newStatus = Integer.parseInt(result.getPacketValue())) != this.model.getDeviceStatus()) {
            this.model.setDeviceStatus(newStatus);
            this.log.debug("deviceStatus set to {}", (Object)newStatus);
        }
        if (result.getPacketCommand().equals("81") && (newStatus = Integer.parseInt(result.getPacketValue())) != this.model.getCashDrawerStatus()) {
            this.model.setCashDrawerStatus(newStatus);
            this.log.debug("cashDrawerStatus set to {}", (Object)newStatus);
        }
    }
}

