/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.com.classic;

import org.comproxy.ProxyModel;
import org.comproxy.com.ByteArrayLog;
import org.comproxy.com.ComConnector;
import org.comproxy.com.serialio.CommonPortReader;
import org.comproxy.com.serialio.PortReaderJssc;
import org.comproxy.com.serialio.SerialPortJssc;
import org.comproxy.config.ContextStore;
import org.comproxy.config.ProxyConfig;
import org.comproxy.reader.ComPacket;
import org.comproxy.reader.PackageReader;
import org.comproxy.utils.PiritCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComThreadBase {
    protected final Logger log = LoggerFactory.getLogger(this.getClass().getName());
    protected PackageReader packageReader;
    protected ProxyModel model;
    private CommonPortReader tunnelPortReader;
    protected ProxyConfig proxyConfig;

    abstract ComConnector getConnector();

    protected void init(Runnable signal) {
        this.proxyConfig = (ProxyConfig)ContextStore.getInstance().get(ProxyConfig.class.getSimpleName());
        this.tunnelPortReader = new PortReaderJssc(this.getConnector().getSerialPort(), signal, this.log);
        try {
            SerialPortJssc serialPortJssc = (SerialPortJssc)this.getConnector().getSerialPort();
            while (!serialPortJssc.isOpened()) {
                try {
                    this.getConnector().directOpenPort();
                    this.getConnector().hwReset();
                    this.log.info("{} Com port name {} opened", (Object)this.model.getLogMark(), (Object)this.getConnector().getPortName());
                }
                catch (Exception e) {
                    this.log.error("Error on open port", e);
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            serialPortJssc.addEventListener((PortReaderJssc)this.tunnelPortReader, 1);
            this.log.info("{} Com port add event listener {} ", (Object)this.model.getLogMark(), (Object)this.getConnector().getPortName());
        }
        catch (Exception e) {
            this.log.error("Error on open port", e);
        }
    }

    protected boolean readFromConnector(ComConnector connector, byte[] buffer) throws Exception {
        boolean needPause = true;
        try {
            while (!Thread.interrupted() && this.model.getHardwareChecker().isFiscalPrinterConnected() && this.isHaveData()) {
                int read = this.readFromConnector(buffer);
                if (read <= 0) continue;
                this.readData(read, buffer);
                needPause = false;
            }
        }
        catch (InterruptedException t) {
            throw t;
        }
        catch (Throwable t) {
            this.log.error("", t);
            Thread.sleep(1000L);
            connector.reconnect();
        }
        return needPause;
    }

    public boolean isHaveData() throws Exception {
        return this.tunnelPortReader.isHaveData();
    }

    protected void readData(int read, byte[] buffer) throws InterruptedException {
        this.log.debug("--> {}", (Object)ByteArrayLog.onlyHex(buffer, read));
        this.packageReader.write(buffer, read);
    }

    private int readFromConnector(byte[] buffer) throws Exception {
        byte[] tempbuffer = this.tunnelPortReader.getBuffer();
        if (tempbuffer != null && tempbuffer.length > 0) {
            int maxBuffer = Math.min(tempbuffer.length, buffer.length);
            System.arraycopy(tempbuffer, 0, buffer, 0, maxBuffer);
            return maxBuffer;
        }
        return 0;
    }

    protected void sendToConnector(ComPacket packet) throws Exception {
        if (packet == null) {
            return;
        }
        if (this.model.getHardwareChecker().isFiscalPrinterConnected()) {
            this.getConnector().getSerialPort().writeBytes(packet.getPacketBody());
            this.log.debug("<-- {}", (Object)packet);
        }
    }

    public boolean isImageCommand(ComPacket packet) {
        return packet.getPacketCommand() != null && PiritCommands.BINARY_COMMANDS.contains(packet.getPacketCommand());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

