/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.comproxy.ComProxyPacketListener;
import org.comproxy.InternalComProxyApi;
import org.comproxy.ProxyModel;
import org.comproxy.RequestedCommand;
import org.comproxy.reader.ComPacket;
import org.comproxy.utils.ComUtils;
import org.comproxy.utils.PiritCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.crystals.agent.agentDataTransfer.utils.ComProxyPacket;
import ru.crystals.agent.agentDataTransfer.utils.CommandResponse;
import ru.crystals.agent.agentDataTransfer.utils.ComplexRequest;
import ru.crystals.agent.agentDataTransfer.utils.ComplexResponse;
import ru.crystals.agent.agentDataTransfer.utils.InfoCommandRequest;
import ru.crystals.utils.time.Timer;

public class SingleComProxyApiImpl
implements InternalComProxyApi {
    private static final int USER_MIN_PACKET_ID = 32;
    private static final int[] PACKET_IDS = new int[]{25, 26, 27, 29, 30, 31};
    private static final Logger log = LoggerFactory.getLogger(SingleComProxyApiImpl.class);
    private final Duration availableTimeout = Duration.ofSeconds(10L);
    private final Timer availableTimer = Timer.expired(this.availableTimeout);
    private final Timer requestTotalTimer = Timer.expired(Duration.ofSeconds(5L));
    private final Timer availableTcpTimer = Timer.expired(Duration.ofSeconds(5L));
    private final ReentrantLock lock = new ReentrantLock();
    private final ReentrantLock queryLock = new ReentrantLock();
    private final ReentrantLock awaitQueryModificationLock = new ReentrantLock();
    private final Condition allProcessed = this.queryLock.newCondition();
    private final LinkedBlockingQueue<RequestedCommand> awaitedRequestsQuery = new LinkedBlockingQueue(1);
    private final Map<InfoCommandRequest, CommandResponse> receivedCommandResponses = new ConcurrentHashMap<InfoCommandRequest, CommandResponse>();
    private final boolean dreamkasMode;
    private final ProxyModel model;
    ComProxyPacketListener listener;

    public SingleComProxyApiImpl(boolean dreamkasMode, ProxyModel model) {
        this.dreamkasMode = dreamkasMode;
        this.model = model;
    }

    @Override
    public void onCommandFromDevice(ComPacket packet) {
        if (this.dreamkasMode) {
            return;
        }
        if (this.listener == null) {
            return;
        }
        if (StringUtils.isEmpty(packet.getPacketCommand())) {
            return;
        }
        String packetCommand = packet.getPacketCommand();
        if (PiritCommands.COUNTERS_CHANGERS.contains(packetCommand)) {
            this.listener.onCountersChanged();
        }
        if (packetCommand.equals("21") || PiritCommands.CASH_INFO_CHANGERS.contains(packetCommand)) {
            this.listener.onCashInfoChanged();
        }
    }

    @Override
    public void onReconnect() {
        if (this.dreamkasMode) {
            return;
        }
        if (this.listener == null) {
            return;
        }
        this.listener.onReconnect();
    }

    @Override
    public boolean toAgent(ComPacket packet) {
        if (packet.getPacketCommand() == null || packet.getPacketId() == null || packet.getPacketId() >= 32) {
            return false;
        }
        this.processToAgent(packet);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processToAgent(ComPacket packet) {
        block13: {
            if (this.dreamkasMode) {
                if (packet.getPacketId() > 2) {
                    this.model.addPacketToAgent(packet);
                }
                return;
            }
            if (this.listener == null) {
                return;
            }
            if (this.awaitedRequestsQuery.peek() == null) {
                return;
            }
            this.lock(this.awaitQueryModificationLock, "awaitQueryModificationLock");
            try {
                RequestedCommand awaited = this.awaitedRequestsQuery.peek();
                if (awaited == null) {
                    return;
                }
                if (awaited.getPacketId() != packet.getPacketId().intValue() || !awaited.getRequest().getCommand().equals(packet.getPacketCommand())) break block13;
                this.receivedCommandResponses.put(awaited.getRequest(), awaited.getRequest().toResponse(packet.getPacketValueOnly()));
                this.lock(this.queryLock, "queryLock");
                RequestedCommand toRemove = this.awaitedRequestsQuery.poll();
                try {
                    if (this.awaitedRequestsQuery.isEmpty()) {
                        this.allProcessed.signal();
                    }
                }
                finally {
                    this.queryLock.unlock();
                }
            }
            finally {
                this.awaitQueryModificationLock.unlock();
            }
        }
    }

    private void lock(ReentrantLock lock, String message) {
        if (!lock.tryLock()) {
            log.debug("Trying to acquire {} lock (in use now)", (Object)message);
            lock.lock();
            log.debug("{} lock acquired", (Object)message);
        }
    }

    @Override
    public void addListener(ComProxyPacketListener listener, int instanceNumber) {
        this.listener = listener;
    }

    @Override
    public boolean isPrinterConnected(int instanceNumber) {
        return this.model.getHardwareChecker().isFiscalPrinterConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(ComPacket result) {
        if (this.dreamkasMode) {
            this.lock(this.lock, "lock");
            try {
                this.model.sendStopTcp();
                this.model.addPacketFromAgent(new ComPacket(result.getPacketBody(), ComPacket.STATUS.PACKET, result.getPacketId(), result.getPacketCommand()));
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.listener == null) {
            return false;
        }
        if (!this.waitForAvailable(this.model)) {
            this.listener.onPacket(new ComProxyPacket(ComUtils.makePiritCommand(result.getPacketId(), result.getPacketCommand(), "01", ""), result.getPacketId(), result.getPacketCommand()));
            return false;
        }
        this.lock(this.lock, "lock");
        try {
            this.model.sendStopTcp();
            this.model.addPacketFromAgent(new ComPacket(result.getPacketBody(), ComPacket.STATUS.PACKET, result.getPacketId(), result.getPacketCommand()));
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean send(ComProxyPacket result) {
        if (!this.waitForAvailable(this.model)) {
            this.listener.onPacket(new ComProxyPacket(ComUtils.makePiritCommand(result.getPacketId(), result.getPacketCommand(), "01", ""), result.getPacketId(), result.getPacketCommand()));
            return false;
        }
        this.lock(this.lock, "lock");
        try {
            this.model.sendStopTcp();
            this.model.addPacketFromAgent(new ComPacket(result.getPacketBody(), ComPacket.STATUS.PACKET, result.getPacketId(), result.getPacketCommand()));
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ComplexResponse send(ComplexRequest request, int recipientNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void clearQuiresWithLock() {
        this.lock(this.awaitQueryModificationLock, "awaitQueryModificationLock");
        try {
            this.awaitedRequestsQuery.clear();
            this.receivedCommandResponses.clear();
        }
        finally {
            this.awaitQueryModificationLock.unlock();
        }
    }

    private boolean waitForAvailable(ProxyModel model) {
        if (model.isAvailableToAgent()) {
            return true;
        }
        log.trace("Waiting for available device");
        this.availableTimer.restart();
        while (!model.isAvailableToAgent() && this.availableTimer.isNotExpired()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return model.isAvailableToAgent();
    }

    private void waitForAvailableTcpRead(ProxyModel model) {
        if (!model.isTcpReadMode()) {
            return;
        }
        log.trace("Waiting for available device (tcp mode)");
        this.availableTcpTimer.restart();
        while (model.isTcpReadMode() && this.availableTcpTimer.isNotExpired()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }
    }
}

