/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.comproxy.Mode;
import org.comproxy.SettingsManager;
import org.comproxy.config.ProxyConfig;

public class ModeManager {
    private final SettingsManager settings;
    private final Map<String, Map<Integer, Mode>> coolDownModes = new HashMap<String, Map<Integer, Mode>>();
    private final ReentrantLock coolDownModeLock = new ReentrantLock();
    private final long coolDownModeTimeout;
    private final int coolDownModeCounter;

    public ModeManager(ProxyConfig proxyConfig, SettingsManager settings) {
        this.coolDownModeTimeout = proxyConfig != null ? proxyConfig.getCoolDownModeTimeout() : ProxyConfig.DEFAULT_COOL_DOWN_MODE_TIMEOUT;
        this.coolDownModeCounter = proxyConfig != null ? proxyConfig.getCoolDownModeCounter() : 5;
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mode getCoolDownMode(String ip, int port) {
        Mode mode = (Mode)this.coolDownModes.getOrDefault(ip, Collections.emptyMap()).get(port);
        if (mode != null) {
            return mode;
        }
        this.coolDownModeLock.lock();
        try {
            Mode modeAgain = (Mode)this.coolDownModes.getOrDefault(ip, Collections.emptyMap()).get(port);
            if (modeAgain != null) {
                Mode mode2 = modeAgain;
                return mode2;
            }
            Mode newMode = new Mode(ip + ":" + port, this.coolDownModeTimeout, this.coolDownModeCounter);
            this.coolDownModes.computeIfAbsent(ip, s -> new HashMap()).put(port, newMode);
            Mode mode3 = newMode;
            return mode3;
        }
        finally {
            this.coolDownModeLock.unlock();
        }
    }
}

