/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.comproxy.AgentServiceController;
import org.comproxy.ComProxy;
import org.comproxy.ComProxyApiHolder;
import org.comproxy.ComProxyApiImpl;
import org.comproxy.CommonResources;
import org.comproxy.InternalComProxyApi;
import org.comproxy.ProxyModel;
import org.comproxy.SingleComProxyApiImpl;
import org.comproxy.SystemInfo;
import org.comproxy.Version;
import org.comproxy.config.ContextStore;
import org.comproxy.config.CustomLogAppender.CustomDailyRollingFileAppender;
import org.comproxy.config.LinuxConnectorChecker;
import org.comproxy.config.ProxyConfig;
import org.comproxy.monitor.MonitorThread;
import org.comproxy.tcp.BackgroundHostResolver;
import org.comproxy.tcp.agentIpTransport.AgentIpTrafficServer;
import org.comproxy.utils.ComUtils;
import org.comproxy.utils.InternalExecutor;
import org.comproxy.utils.WinRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static final String LOG_DIR = "logs";
    private static final String LOG_FILE_NAME = "comProxy.log";
    private static String logsPath;
    private static String homePath;
    private static final String CONFIG_FILE_NAME = "ComProxy.ini";
    private static ComProxy comProxy;
    private static ComProxy comProxyTwo;
    private static AgentIpTrafficServer agentIpTrafficServer;
    private static AgentServiceController agentServiceController;

    public Main(String homePath) {
        if (homePath == null) {
            homePath = System.getProperty("user.dir");
        }
        Main.homePath = homePath;
        logsPath = Main.resolve(homePath, LOG_DIR);
        try {
            new File(logsPath).mkdirs();
        }
        catch (Exception e) {
            System.err.println("Create " + logsPath + " dir failed");
            e.printStackTrace();
        }
        ProxyConfig proxyConfig = new ProxyConfig(homePath, CONFIG_FILE_NAME);
        ContextStore.getInstance().put(ProxyConfig.class.getSimpleName(), proxyConfig);
        Main.configureLogger(proxyConfig);
        LOG.error("ComProxy version : {}", (Object)Version.getVersion());
        SystemInfo info = new SystemInfo();
        LOG.debug("OS {}", (Object)info.getOsName());
        LOG.debug("OS ver {}", (Object)info.getOsVersion());
        boolean twoFrMode = ComUtils.checkConfigForTwoPrinters(proxyConfig);
        try {
            String e;
            if (info.isLinux() && proxyConfig.getFindPidVid() && !twoFrMode && !(e = LinuxConnectorChecker.chekPiritLinuxConnection()).equals("")) {
                proxyConfig.getPhysicalPortPrinter1(e);
                LOG.error("Set PhysicalPort - {} in ComProxy.ini ", (Object)e);
            }
            if (proxyConfig.isLoadXmlFailed()) {
                LOG.debug("Load xml config failed");
            }
            if (proxyConfig.isLoadXmlDefault()) {
                LOG.debug("Load default config");
            }
            LOG.debug("{}", (Object)proxyConfig);
            ProxyModel proxyModelTwo = null;
            CommonResources.getInstance().setProxyConfig(proxyConfig);
            int threadCount = this.calculateThreadPoolSize(twoFrMode, proxyConfig);
            LOG.trace("Initial thread pool count: {}", (Object)threadCount);
            InternalExecutor pool = new InternalExecutor(threadCount);
            CommonResources.getInstance().setPool(pool);
            ComProxyApiHolder.setPool(pool);
            CommonResources.getInstance().setHostResolver(new BackgroundHostResolver(pool, proxyConfig));
            if (twoFrMode) {
                LOG.debug("Start service for two printers ");
                comProxyTwo = new ComProxy(proxyConfig, 2);
                proxyModelTwo = comProxyTwo.getModel();
                CommonResources.getInstance().putProxyModel(proxyModelTwo.getInstanceNumber(), proxyModelTwo);
            }
            comProxy = new ComProxy(proxyConfig, 1);
            CommonResources.getInstance().putProxyModel(comProxy.getModel().getInstanceNumber(), comProxy.getModel());
            MonitorThread monitorThread = new MonitorThread(pool);
            pool.submit(monitorThread, "MonitorThread", true);
            this.tryToDeleteOldParts();
            this.startAgent(proxyConfig);
        }
        catch (Exception e) {
            LOG.error("Could not create instance of ComProxy", e);
        }
    }

    private int calculateThreadPoolSize(boolean twoFrMode, ProxyConfig proxyConfig) {
        int perDeviceThreadCount = 3;
        boolean commonThreadCount = true;
        boolean extraThreadCount = true;
        int totalThreadCount = 5;
        if (proxyConfig.getStartPosIp1()) {
            ++totalThreadCount;
        }
        if (twoFrMode) {
            totalThreadCount += 3;
            if (proxyConfig.getStartPosIp2()) {
                ++totalThreadCount;
            }
        }
        if (proxyConfig.isStartAgent()) {
            ++totalThreadCount;
        }
        return totalThreadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToDeleteOldParts() {
        block20: {
            if (!SystemUtils.IS_OS_WINDOWS) {
                try {
                    new File("gui_stop.tsk").delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            File cpa = new File(Main.resolve(homePath, "ComProxyAgent.jar"));
            File sa = new File(Main.resolve(homePath, "StartAgent.cmd"));
            if (cpa.exists() || sa.exists()) {
                this.stopComProxyAgent();
            } else {
                try {
                    new File(Main.resolve(homePath, "gui_stop.tsk")).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (cpa.exists()) {
                    cpa.delete();
                }
            }
            catch (Exception e) {
                LOG.trace("Error on delete ComProxyAgent.jar: {}", (Object)e.getMessage());
            }
            try {
                String key = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run";
                String value = "StartAgent";
                String startAgent = WinRegistry.readString("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run", "StartAgent");
                if (startAgent != null && startAgent.contains("StartAgent.cmd")) {
                    try (BufferedWriter output = null;){
                        output = new BufferedWriter(new FileWriter(sa));
                        output.write(String.format("Reg delete \"HKLM\\%s\" /v \"StartAgent\" /f", "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run"));
                        output.flush();
                        break block20;
                    }
                }
                try {
                    if (sa.exists()) {
                        sa.delete();
                    }
                }
                catch (Exception e) {
                    LOG.trace("Error on delete StartAgent.cmd: {}", (Object)e.getMessage());
                }
            }
            catch (Exception e) {
                LOG.trace("Error on remove ComProxyAgent form registry: {}", (Object)e.getMessage());
            }
        }
    }

    private void stopComProxyAgent() {
        try {
            File stopGui = new File(Main.resolve(homePath, "gui_stop.tsk"));
            if (!stopGui.exists()) {
                stopGui.createNewFile();
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to handle stop gui file: {}", (Object)e.getMessage());
        }
    }

    public static void configureLogger(Level logLevel, int maxLogDays, boolean createZip) {
        LogManager.resetConfiguration();
        String LOGGER_PATTERN = "%d{dd.MM HH:mm:ss.SSS} %-5p [%-25c{1}][%X{MARK}] %m | %t%n";
        ConsoleAppender console = new ConsoleAppender();
        console.setLayout(new PatternLayout(LOGGER_PATTERN));
        console.setThreshold(logLevel);
        console.activateOptions();
        CustomDailyRollingFileAppender fa = new CustomDailyRollingFileAppender();
        fa.setName("FileLogger");
        fa.setFile(Main.resolve(logsPath, LOG_FILE_NAME));
        fa.setLayout(new PatternLayout(LOGGER_PATTERN));
        fa.setDatePattern("'.'yyyy-MM-dd");
        fa.setMaxBackupIndex(maxLogDays);
        fa.setCreateZipArchive(createZip);
        fa.setThreshold(logLevel);
        fa.setAppend(true);
        fa.setEncoding("UTF-8");
        fa.activateOptions();
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger("org.comproxy");
        logger.setLevel(logLevel);
        logger.addAppender(console);
        logger.addAppender(fa);
    }

    public static void configureLogger(ProxyConfig config) {
        Main.configureLogger(config.getLogLevel(), config.getMaxDayIndex(), config.getCreateZip());
    }

    public static String getLogFileName() {
        return LOG_FILE_NAME;
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            new Main(args[0]);
        } else {
            new Main(null);
        }
    }

    public static void start(String ... args) throws Exception {
        new Main(null);
    }

    public static void stop(String ... args) {
        try {
            LOG.debug("Receive - Service stopMonitor");
            if (agentIpTrafficServer != null) {
                agentIpTrafficServer.stopServer();
            }
            ScheduledExecutorService pool = CommonResources.getInstance().getPool().getPool();
            try {
                pool.shutdown();
                pool.awaitTermination(1L, TimeUnit.SECONDS);
                pool.shutdownNow();
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
            }
            catch (Exception e) {
                LOG.error("Error on stop", e);
            }
            if (comProxy != null) {
                try {
                    comProxy.stop();
                }
                catch (Exception ex) {
                    LOG.error("", ex);
                }
            }
            if (comProxyTwo != null) {
                comProxyTwo.stop();
            }
        }
        catch (Exception ex) {
            LOG.error("", ex);
        }
        System.exit(0);
    }

    private static String resolve(String path, String pathToResolve) {
        if (path.endsWith(File.separator)) {
            return path + pathToResolve;
        }
        return path + File.separator + pathToResolve;
    }

    private void startAgent(ProxyConfig proxyConfig) {
        if (!proxyConfig.isStartAgent()) {
            LOG.debug("Start without agent due to config");
            return;
        }
        agentServiceController = new AgentServiceController(Main.resolve(homePath, "AgentService.jar"), homePath, proxyConfig.isLocalAgent());
        if (!this.canBeUsed()) {
            return;
        }
        if (agentServiceController.isDreamkasMode()) {
            agentIpTrafficServer = new AgentIpTrafficServer(proxyConfig.getAgentDataPort());
            agentIpTrafficServer.start();
        }
        SingleComProxyApiImpl firstDeviceApi = new SingleComProxyApiImpl(agentServiceController.isDreamkasMode(), comProxy.getModel());
        comProxy.getModel().setComProxyApi(firstDeviceApi);
        if (comProxyTwo != null) {
            HashMap<Integer, InternalComProxyApi> comProxyApiMap = new HashMap<Integer, InternalComProxyApi>(2);
            comProxyApiMap.put(comProxy.getModel().getInstanceNumber(), firstDeviceApi);
            SingleComProxyApiImpl secondDeviceApi = new SingleComProxyApiImpl(agentServiceController.isDreamkasMode(), comProxyTwo.getModel());
            comProxyApiMap.put(comProxyTwo.getModel().getInstanceNumber(), secondDeviceApi);
            comProxyTwo.getModel().setComProxyApi(firstDeviceApi);
            ComProxyApiHolder.setApi(new ComProxyApiImpl(comProxyApiMap));
        } else {
            ComProxyApiHolder.setApi(firstDeviceApi);
        }
        for (Map.Entry<Integer, ProxyModel> modelEntry : CommonResources.getInstance().entrySet()) {
            modelEntry.getValue().setStartAgent(true);
        }
        agentServiceController.start();
    }

    private boolean canBeUsed() {
        if (agentServiceController.isDreamkasMode()) {
            return true;
        }
        for (Map.Entry<Integer, ProxyModel> modelEntry : CommonResources.getInstance().entrySet()) {
            try {
                ProxyModel model = modelEntry.getValue();
                if (!this.isAgentSupported(model)) {
                    LOG.debug("Starting without agent due to not supported by device #{} ({})", (Object)modelEntry.getKey(), (Object)model.getKktVersion());
                    return false;
                }
                LOG.debug("Device #{} ({}) supports agent", (Object)modelEntry.getKey(), (Object)model.getKktVersion());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.debug("Starting agent interrupted");
                return false;
            }
        }
        return true;
    }

    private boolean isAgentSupported(ProxyModel model) throws InterruptedException {
        while (!Thread.interrupted()) {
            Boolean agentSupportedByKkt = model.isAgentSupportedByKkt();
            if (agentSupportedByKkt == null) {
                Thread.sleep(1000L);
                continue;
            }
            return agentSupportedByKkt;
        }
        LOG.debug("Starting agent interrupted (while condition failed)");
        return false;
    }

    static {
        agentIpTrafficServer = null;
    }
}

