/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy;

import org.comproxy.CommonResources;
import org.comproxy.ProxyModel;
import org.comproxy.com.ComConnector;
import org.comproxy.com.classic.PhysicalComThread;
import org.comproxy.com.classic.PosVirtualComThread;
import org.comproxy.com.classic.VirtualComThread;
import org.comproxy.config.ProxyConfig;
import org.comproxy.config.portFinder.PortFinderModel;
import org.comproxy.tcp.InternalExecutorApi;
import org.comproxy.tcp.TCPService;
import org.comproxy.tcp.TCPThread;
import org.comproxy.tcp.posIpTransport.PosIpTrafficServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComProxy {
    private static final Logger LOG = LoggerFactory.getLogger(ComProxy.class);
    private InternalExecutorApi pool = CommonResources.getInstance().getPool();
    private PosIpTrafficServer cashTrafficServer;
    private ProxyModel model;
    private ComConnector physicalConnector;
    private ComConnector virtualConnector;
    private ComConnector posVirtualConnector;
    private ProxyConfig proxyConfig;
    private final String logMark;
    private boolean posIpMode = false;
    private boolean portFounded = false;
    private int instanceNumber;
    private String printerSerialNumber = "";
    private int posServerPort = 50001;
    private String configuredPort;

    public ComProxy(ProxyConfig proxyConfig, int instanceNumber) throws Exception {
        this.proxyConfig = proxyConfig;
        this.logMark = "P" + instanceNumber;
        this.instanceNumber = instanceNumber;
        this.configuredPort = instanceNumber == 2 ? proxyConfig.getPhysicalPortPrinter2() : proxyConfig.getPhysicalPortPrinter1();
        try {
            this.initPoolExecutor();
            this.setComConnectors();
            this.init();
        }
        catch (Exception ex) {
            LOG.error("{} ", (Object)this.logMark, (Object)ex);
            throw ex;
        }
    }

    public ProxyModel getModel() {
        return this.model;
    }

    private void initPoolExecutor() {
    }

    private void init() throws Exception {
        LOG.debug(this.logMark + " {}", (Object)"Service load COM mode");
        this.model = new ProxyModel(this.physicalConnector, this.virtualConnector, this.logMark, this.printerSerialNumber, this.proxyConfig);
        this.setInstanceParams();
        this.model.setTcpService(new TCPService(this.model));
        if (this.posIpMode) {
            this.model.setPosVirtualConnector(this.posVirtualConnector);
            this.pool.submit(new PosVirtualComThread(this.model), "posVirtualCom", this.model.getLogMark(), true);
            this.cashTrafficServer = new PosIpTrafficServer(this.model);
            this.cashTrafficServer.setServerPort(this.posServerPort);
            this.cashTrafficServer.start();
        }
        this.model.getHardwareChecker().start();
        this.model.waitForFRConnected();
        this.pool.submit(new PhysicalComThread(this.model), "physicalCom", this.model.getLogMark(), true);
        this.pool.submit(new VirtualComThread(this.model), "virtualCom", this.model.getLogMark(), true);
        this.model.sendFailTcpCommandToPhysic();
        this.pool.submit(new TCPThread(this.model), "tcp", this.model.getLogMark(), true);
    }

    private void setComConnectors() {
        this.portFounded = false;
        if (this.instanceNumber < 2) {
            LOG.info(this.logMark + " setComConnectors {}", (Object)this.instanceNumber);
            if (!this.proxyConfig.getPrinterSerialNumber1().equals("")) {
                this.printerSerialNumber = this.proxyConfig.getPrinterSerialNumber1();
                this.proxyConfig.getPhysicalPortPrinter1(this.getPortNameBySerialNumber(this.printerSerialNumber));
            }
            this.physicalConnector = new ComConnector(this.proxyConfig.getPhysicalPortPrinter1(), this.proxyConfig.getPhysicalSpeedPrinter1(), this.logMark);
            this.virtualConnector = new ComConnector(this.proxyConfig.getVirtualPortPrinter1(), this.proxyConfig.getVirtualSpeedPrinter1(), this.logMark);
            this.posIpMode = this.proxyConfig.getStartPosIp1();
            if (this.posIpMode) {
                this.posServerPort = Integer.parseInt(this.proxyConfig.getPosTcpPortFr1());
                this.posVirtualConnector = new ComConnector(this.proxyConfig.getVirtualPortPrinter1Out(), this.proxyConfig.getVirtualSpeedPrinter1(), this.logMark);
            }
        } else {
            LOG.info(this.logMark + " setComConnectors {}", (Object)this.instanceNumber);
            if (!this.proxyConfig.getPrinterSerialNumber2().equals("")) {
                this.printerSerialNumber = this.proxyConfig.getPrinterSerialNumber2();
                this.proxyConfig.setPhysicalPortPrinter2(this.getPortNameBySerialNumber(this.printerSerialNumber));
            }
            LOG.info(this.logMark + " Founded PortNameBySerialNumber  2");
            this.physicalConnector = new ComConnector(this.proxyConfig.getPhysicalPortPrinter2(), this.proxyConfig.getPhysicalSpeedPrinter2(), this.logMark);
            this.virtualConnector = new ComConnector(this.proxyConfig.getVirtualPortPrinter2(), this.proxyConfig.getVirtualSpeedPrinter2(), this.logMark);
            this.posIpMode = this.proxyConfig.getStartPosIp2();
            if (this.posIpMode) {
                this.posServerPort = Integer.parseInt(this.proxyConfig.getPosTcpPortFr2());
                this.posVirtualConnector = new ComConnector(this.proxyConfig.getVirtualPortPrinter2Out(), this.proxyConfig.getVirtualSpeedPrinter2(), this.logMark);
            }
        }
    }

    private void setInstanceParams() {
        this.model.getHardwareChecker().setProxyConfig(this.proxyConfig);
        this.model.setInstanceNumber(this.instanceNumber);
        if (this.instanceNumber < 2) {
            this.model.getHardwareChecker().setUsbConnection(this.proxyConfig.isUSBconnectionOfPrinter1());
        } else {
            this.model.getHardwareChecker().setUsbConnection(this.proxyConfig.isUSBconnectionOfPrinter2());
        }
    }

    private String getPortNameBySerialNumber(String serialNumber) {
        LOG.info(this.logMark + " getPortNameBySerialNumber {} portFounded {}", (Object)serialNumber, (Object)this.portFounded);
        while (!this.portFounded) {
            LOG.debug(this.logMark + " {} FIND FOR {} portFounded {}", this, serialNumber, this.portFounded);
            String portResult = this.proxyConfig.isFastStart() ? this.configuredPort : PortFinderModel.getInstance().findPort(serialNumber, this.proxyConfig, this.logMark);
            if (portResult != null) {
                this.portFounded = true;
                LOG.debug(this.logMark + " Init Find port name for serial number {} stop find  portFounded {}", (Object)serialNumber, (Object)this.portFounded);
                return portResult;
            }
            try {
                LOG.debug(this.logMark + " Can not find port name for serial number {} ", (Object)serialNumber);
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        LOG.info(this.logMark + " return getPortNameBySerialNumber {} portFounded {}", (Object)serialNumber, (Object)this.portFounded);
        return "";
    }

    public void stop() {
        if (this.physicalConnector != null) {
            this.physicalConnector.close();
        }
        if (this.virtualConnector != null) {
            this.virtualConnector.close();
        }
        if (this.posVirtualConnector != null) {
            this.posVirtualConnector.close();
        }
        if (this.cashTrafficServer != null) {
            this.cashTrafficServer.stopServer();
        }
    }
}

