/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.utils.time;

import java.time.Duration;
import ru.crystals.utils.time.DurationFormatter;
import ru.crystals.utils.time.StopTimer;

public class Timer {
    private final StopTimer stopTimer;
    private volatile long timeout;
    private volatile boolean initiallyExpired;

    Timer(Duration timeout, StopTimer stopTimer, boolean initiallyExpired) {
        this.timeout = timeout.toNanos();
        this.stopTimer = stopTimer;
        this.initiallyExpired = initiallyExpired;
    }

    public static Timer of(Duration timeout) {
        return new Timer(timeout, new StopTimer(), false);
    }

    @Deprecated
    public static Timer ofMillis(long timeoutMillis) {
        return Timer.of(Duration.ofMillis(timeoutMillis));
    }

    public static Timer expired(Duration timeout) {
        return new Timer(timeout, new StopTimer(), true);
    }

    public Timer restart(Duration timeout) {
        this.timeout = timeout.toNanos();
        return this.restart();
    }

    public Timer restart() {
        this.initiallyExpired = false;
        this.stopTimer.restart();
        return this;
    }

    public boolean isNotExpired() {
        return !this.isExpired();
    }

    public boolean isExpired() {
        return this.initiallyExpired || this.getElapsedNanos() >= this.timeout;
    }

    public boolean isInitiallyExpired() {
        return this.initiallyExpired;
    }

    public Duration getRemain() {
        long remainNanos = this.getRemainNanos();
        if (remainNanos == 0L) {
            return Duration.ZERO;
        }
        return Duration.ofNanos(remainNanos);
    }

    public long getRemainNanos() {
        if (this.initiallyExpired) {
            return 0L;
        }
        return this.timeout - this.getElapsedNanos();
    }

    public long getElapsedNanos() {
        if (this.initiallyExpired) {
            return 0L;
        }
        return this.stopTimer.getElapsedNanos();
    }

    public Duration getElapsed() {
        long elapsedNanos = this.getElapsedNanos();
        if (elapsedNanos == 0L) {
            return Duration.ZERO;
        }
        return Duration.ofNanos(elapsedNanos);
    }

    public String getElapsedTimeAsString() {
        return DurationFormatter.formatDuration(this.getElapsedNanos());
    }

    public String getRemainTimeAsString() {
        return DurationFormatter.formatDuration(this.getRemainNanos());
    }
}

