/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.agent.agentDataTransfer.utils;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import ru.crystals.agent.agentDataTransfer.utils.CommandResponse;

public class InfoCommandRequest {
    public static final String FS = "\u001c";
    public static final Charset CP_866 = Charset.forName("cp866");
    private final String command;
    private final String extCommand;
    private final List<String> params;
    private final String preparedData;
    private final byte[] preparedDataBytes;

    public InfoCommandRequest(String command, String extCommand, List<String> params) {
        this.command = command;
        this.extCommand = extCommand;
        this.params = params;
        if (params.isEmpty() && extCommand == null) {
            this.preparedData = command;
        } else {
            StringBuilder sb = new StringBuilder(command);
            if (extCommand != null) {
                sb.append(extCommand).append(FS);
            }
            for (String param : params) {
                sb.append(param).append(FS);
            }
            this.preparedData = sb.toString();
        }
        this.preparedDataBytes = this.preparedData.getBytes(CP_866);
    }

    public InfoCommandRequest(String command) {
        this(command, null, Collections.emptyList());
    }

    public InfoCommandRequest(String command, String extCommand) {
        this(command, extCommand, Collections.emptyList());
    }

    public InfoCommandRequest(String command, List<String> params) {
        this(command, null, params);
    }

    public String getCommand() {
        return this.command;
    }

    public String getExtCommand() {
        return this.extCommand;
    }

    public List<String> getParams() {
        return this.params;
    }

    public String getPreparedData() {
        return this.preparedData;
    }

    public byte[] getPreparedDataBytes() {
        return this.preparedDataBytes;
    }

    public String getValue(CommandResponse response) {
        return response.getStringSafe(0);
    }

    public int getIntValue(CommandResponse response) {
        return response.getInt(0);
    }

    public long getLongValue(CommandResponse response) {
        return response.getLong(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InfoCommandRequest)) {
            return false;
        }
        InfoCommandRequest that = (InfoCommandRequest)o;
        return Objects.equals(this.command, that.command) && Objects.equals(this.extCommand, that.extCommand) && Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.command, this.extCommand, this.params);
    }

    public CommandResponse toResponse(String packet) {
        String[] parts = StringUtils.splitPreserveAllTokens(packet, FS);
        String errorCode = parts[0].substring(2, 4);
        if (!errorCode.equals("00")) {
            return CommandResponse.withError(errorCode);
        }
        if (this.extCommand == null) {
            String firstParam = parts[0].substring(4);
            if (parts.length == 1) {
                return CommandResponse.with(firstParam);
            }
            ArrayList<String> objects = new ArrayList<String>();
            objects.add(firstParam);
            for (int i = 1; i < parts.length; ++i) {
                objects.add(parts[i]);
            }
            return CommandResponse.with(objects);
        }
        return CommandResponse.with(Arrays.asList(parts).subList(1, parts.length));
    }

    public String toString() {
        return "InfoCommandRequest{command='" + this.command + '\'' + ", extCommand='" + this.extCommand + '\'' + ", params=" + this.params + '}';
    }
}

