/*
 * Decompiled with CFR 0.152.
 */
package ru.crystals.agent.agentDataTransfer.utils;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.crystals.agent.agentDataTransfer.utils.CommandResponse;
import ru.crystals.agent.agentDataTransfer.utils.InfoCommandRequest;

public class ComplexResponse {
    private final Map<InfoCommandRequest, CommandResponse> responses;
    private static final Logger log = LoggerFactory.getLogger(ComplexResponse.class);

    public ComplexResponse(Map<InfoCommandRequest, CommandResponse> responses) {
        this.responses = responses;
    }

    public Map<InfoCommandRequest, CommandResponse> getResponses() {
        return this.responses;
    }

    public <C extends InfoCommandRequest, T> T getValue(C command, BiFunction<C, CommandResponse, T> extractor) {
        CommandResponse commandResponse = this.extractValidResponse(command, false);
        if (commandResponse == null) {
            return null;
        }
        return extractor.apply(command, commandResponse);
    }

    public <C extends InfoCommandRequest, T> void extractValue(C command, BiFunction<C, CommandResponse, T> extractor, Consumer<T> setter) {
        this.extractValue(command, extractor, setter, false);
    }

    public <C extends InfoCommandRequest, T> void extractValue(C command, BiFunction<C, CommandResponse, T> extractor, Consumer<T> setter, boolean ignoreErrors) {
        CommandResponse commandResponse = this.extractValidResponse(command, ignoreErrors);
        if (commandResponse == null) {
            setter.accept(null);
            return;
        }
        T apply = extractor.apply(command, commandResponse);
        setter.accept(apply);
    }

    private <C extends InfoCommandRequest> CommandResponse extractValidResponse(C command, boolean ignoreErrors) {
        CommandResponse commandResponse = this.getResponses().get(command);
        if (commandResponse == null) {
            log.warn("No response for {}", (Object)command);
            return null;
        }
        if (commandResponse.getErrorCode() != null && !ignoreErrors) {
            log.warn("Error response ({}) for {}", (Object)commandResponse.getErrorCode(), (Object)command);
            return null;
        }
        return commandResponse;
    }
}

