/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.utils;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class TaskParams {
    private final String taskName;
    private final int priority;
    private final boolean singleInstance;
    private String logMark;

    private TaskParams(String taskName, int priority, boolean singleInstance) {
        Objects.requireNonNull(StringUtils.trimToNull(taskName), "taskName should not be null or blank");
        this.taskName = taskName;
        this.priority = priority;
        this.singleInstance = singleInstance;
    }

    public static TaskParams of(String taskName) {
        return TaskParams.normPriority(taskName);
    }

    public static TaskParams normPriority(String taskName) {
        return TaskParams.normPriority(taskName, false);
    }

    public static TaskParams normPriority(String taskName, boolean singleInstance) {
        return new TaskParams(taskName, 5, singleInstance);
    }

    public static TaskParams minPriority(String taskName) {
        return TaskParams.minPriority(taskName, false);
    }

    public static TaskParams minPriority(String taskName, boolean singleInstance) {
        return new TaskParams(taskName, 1, singleInstance);
    }

    public static TaskParams maxPriority(String taskName) {
        return TaskParams.maxPriority(taskName, false);
    }

    public static TaskParams maxPriority(String taskName, boolean singleInstance) {
        return new TaskParams(taskName, 10, singleInstance);
    }

    public int getPriority() {
        return this.priority;
    }

    public String formatTaskName(int taskHashCode) {
        return this.taskName + (this.singleInstance ? "" : "@" + Integer.toHexString(taskHashCode));
    }

    public String getLogMark() {
        return this.logMark;
    }

    public void setLogMark(String logMark) {
        this.logMark = logMark;
    }
}

