/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.tcp.posIpTransport;

import java.io.IOException;
import java.net.Socket;
import org.comproxy.ProxyModel;
import org.comproxy.tcp.posIpTransport.PosIpTrafficReader;
import org.comproxy.tcp.posIpTransport.PosIpTrafficWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosIpTransport
implements Runnable {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    protected ProxyModel model;
    private Socket socket;
    private volatile boolean active;
    protected PosIpTrafficReader posIpTrafficReader;
    protected PosIpTrafficWriter posIpTrafficWriter;

    public PosIpTransport(Socket socket, ProxyModel model) throws IOException {
        this.socket = socket;
        this.model = model;
        this.posIpTrafficReader = new PosIpTrafficReader(socket, model);
        this.posIpTrafficWriter = new PosIpTrafficWriter(socket, model);
        this.active = true;
    }

    @Override
    public void run() {
        this.model.setLogMarkMdc();
        try {
            this.active = true;
            this.posIpTrafficReader.start();
            this.posIpTrafficWriter.start();
            while (!Thread.interrupted()) {
                if (!this.posIpTrafficReader.isInterrupted() && !this.posIpTrafficReader.isActive()) {
                    this.active = false;
                    this.posIpTrafficReader.interrupt();
                    this.posIpTrafficWriter.interrupt();
                }
                if (!this.posIpTrafficWriter.isInterrupted() && !this.posIpTrafficWriter.isActive()) {
                    this.active = false;
                    this.posIpTrafficWriter.interrupt();
                    this.posIpTrafficReader.interrupt();
                }
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.LOG.error("Error", e);
        }
        finally {
            try {
                this.posIpTrafficReader.interrupt();
                this.posIpTrafficWriter.interrupt();
                this.socket.close();
            }
            catch (Exception e) {
                this.LOG.error("Error", e);
            }
        }
        this.LOG.info("PosIpTransport finished");
    }

    public boolean isActive() {
        return this.active;
    }
}

