/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.tcp.posIpTransport;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.comproxy.ProxyModel;
import org.comproxy.com.ByteArrayLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosIpTrafficWriter
extends Thread {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    protected ProxyModel model;
    private Socket socket;
    private DataOutputStream bos;
    private volatile boolean active;

    public PosIpTrafficWriter(Socket s, ProxyModel model) throws IOException {
        this.socket = s;
        this.model = model;
        this.bos = new DataOutputStream(s.getOutputStream());
        this.active = true;
    }

    @Override
    public void run() {
        this.model.setLogMarkMdc();
        try {
            while (!Thread.interrupted()) {
                byte[] packet = this.getCommandForSend();
                if (packet == null) continue;
                this.send(this.bos, packet);
            }
        }
        catch (Exception e) {
            this.LOG.error("Error", e);
        }
        finally {
            try {
                this.closeStream();
                this.socket.close();
            }
            catch (Exception e) {
                this.LOG.error("Error", e);
            }
        }
        this.LOG.info("PosIpTrafficWriter finished");
    }

    private void send(OutputStream out, byte[] packet) throws IOException {
        try {
            out.write(packet);
            out.flush();
            this.LOG.debug("<-- {}", (Object)new ByteArrayLog(packet));
        }
        catch (IOException eio) {
            this.LOG.error("SocketReader error", eio);
            Thread.currentThread().interrupt();
            this.closeStream();
            this.active = false;
        }
    }

    protected byte[] getCommandForSend() {
        return this.model.getCommandToIPCashTcp();
    }

    public boolean isActive() {
        return this.active;
    }

    private void closeStream() {
        if (this.bos != null) {
            try {
                this.bos.close();
                this.bos = null;
            }
            catch (IOException e) {
                this.LOG.error("Error input stream error{}", (Object)e.getMessage());
            }
        }
    }
}

