/*
 * Decompiled with CFR 0.152.
 */
package org.comproxy.tcp.posIpTransport;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import org.comproxy.ProxyModel;
import org.comproxy.com.ByteArrayLog;
import org.comproxy.reader.ComPacket;
import org.comproxy.reader.PackageReader;
import org.comproxy.reader.PackageReaderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosIpTrafficReader
extends Thread
implements PackageReaderListener {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    protected ProxyModel model;
    private Socket socket;
    private DataInputStream bis;
    private PackageReader packageReader;
    private volatile boolean active;
    private byte[] data = new byte[4096];
    private int byteCount = 0;

    public PosIpTrafficReader(Socket s, ProxyModel model) throws IOException {
        this.socket = s;
        this.model = model;
        this.bis = new DataInputStream(s.getInputStream());
        this.active = true;
        this.packageReader = new PackageReader(true, this);
    }

    @Override
    public void run() {
        this.model.setLogMarkMdc();
        try {
            while (!Thread.interrupted()) {
                this.readData(this.bis);
            }
        }
        catch (Exception e) {
            this.LOG.error("Error", e);
        }
        finally {
            try {
                this.closeStream();
                this.socket.close();
            }
            catch (Exception e) {
                this.LOG.error("Error", e);
            }
        }
        this.LOG.info("PosIpTrafficReader finished");
    }

    private void readData(DataInputStream in) {
        try {
            this.byteCount = in.read(this.data);
            if (this.byteCount > 0) {
                byte[] methodBuffer = new byte[this.byteCount];
                System.arraycopy(this.data, 0, methodBuffer, 0, this.byteCount);
                this.LOG.debug("--> {}", (Object)new ByteArrayLog(methodBuffer));
                this.packageReader.write(methodBuffer, this.byteCount);
            } else if (this.byteCount < 0) {
                throw new IOException("Socket close");
            }
        }
        catch (IOException eio) {
            this.LOG.error("Error", eio);
            Thread.currentThread().interrupt();
            this.closeStream();
            this.active = false;
        }
    }

    @Override
    public void command(ComPacket result) {
        this.sendReadedPacket(result);
        this.LOG.debug("to physical --> {}", (Object)result);
    }

    private void sendReadedPacket(ComPacket result) {
        this.model.sendCommandToPos(result.getPacketBody());
    }

    public boolean isActive() {
        return this.active;
    }

    private void closeStream() {
        if (this.bis != null) {
            try {
                this.bis.close();
                this.bis = null;
            }
            catch (IOException e) {
                this.LOG.error("Error input stream error{}", (Object)e.getMessage());
            }
        }
    }
}

